/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.edit;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_Reverse3DLine
extends DeterministicScalarFunction {
    private static final GeometryFactory FACTORY = new GeometryFactory();

    public ST_Reverse3DLine() {
        this.addProperty("remarks", "Returns a 1 dimension geometry with vertex order reversed according \n the ascending z values. \nThe z of the first point must be lower than the z of the end point.\n If the z values are equal to NaN return the input geometry. ");
    }

    public String getJavaStaticMethod() {
        return "reverse3DLine";
    }

    public static Geometry reverse3DLine(Geometry geometry) {
        return ST_Reverse3DLine.reverse3DLine(geometry, "asc");
    }

    public static Geometry reverse3DLine(Geometry geometry, String order) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof LineString) {
            return ST_Reverse3DLine.reverse3D((LineString)geometry, order);
        }
        if (geometry instanceof MultiLineString) {
            return ST_Reverse3DLine.reverse3D((MultiLineString)geometry, order);
        }
        return null;
    }

    private static LineString reverse3D(LineString lineString, String order) {
        CoordinateSequence seq = lineString.getCoordinateSequence();
        double startZ = seq.getCoordinate((int)0).z;
        double endZ = seq.getCoordinate((int)(seq.size() - 1)).z;
        if (order.equalsIgnoreCase("desc")) {
            if (!Double.isNaN(startZ) && !Double.isNaN(endZ) && startZ < endZ) {
                CoordinateSequences.reverse((CoordinateSequence)seq);
                return FACTORY.createLineString(seq);
            }
        } else if (order.equalsIgnoreCase("asc")) {
            if (!Double.isNaN(startZ) && !Double.isNaN(endZ) && startZ > endZ) {
                CoordinateSequences.reverse((CoordinateSequence)seq);
                return FACTORY.createLineString(seq);
            }
        } else {
            throw new IllegalArgumentException("Supported order values are asc or desc.");
        }
        return lineString;
    }

    public static MultiLineString reverse3D(MultiLineString multiLineString, String order) {
        int num = multiLineString.getNumGeometries();
        LineString[] lineStrings = new LineString[num];
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            lineStrings[i] = ST_Reverse3DLine.reverse3D((LineString)multiLineString.getGeometryN(i), order);
        }
        return FACTORY.createMultiLineString(lineStrings);
    }
}

