/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import java.sql.SQLException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_RemovePoints
extends DeterministicScalarFunction {
    public ST_RemovePoints() {
        this.addProperty("remarks", "Remove all points on a geometry that are located within a polygon.");
    }

    public String getJavaStaticMethod() {
        return "removePoint";
    }

    public static Geometry removePoint(Geometry geometry, Polygon polygon) throws SQLException {
        if (geometry == null) {
            return null;
        }
        GeometryEditor localGeometryEditor = new GeometryEditor();
        PolygonDeleteVertexOperation localBoxDeleteVertexOperation = new PolygonDeleteVertexOperation(geometry.getFactory(), new PreparedPolygon((Polygonal)polygon));
        Geometry localGeometry = localGeometryEditor.edit(geometry, (GeometryEditor.GeometryEditorOperation)localBoxDeleteVertexOperation);
        if (localGeometry.isEmpty()) {
            return null;
        }
        return localGeometry;
    }

    private static class PolygonDeleteVertexOperation
    extends GeometryEditor.CoordinateOperation {
        private final GeometryFactory GF;
        private PreparedPolygon polygon;

        public PolygonDeleteVertexOperation(GeometryFactory GF, PreparedPolygon polygon) {
            this.polygon = polygon;
            this.GF = GF;
        }

        public Coordinate[] edit(Coordinate[] paramArrayOfCoordinate, Geometry paramGeometry) {
            Coordinate[] arrayOfCoordinate2;
            if (!this.polygon.intersects(paramGeometry)) {
                return paramArrayOfCoordinate;
            }
            Coordinate[] arrayOfCoordinate1 = new Coordinate[paramArrayOfCoordinate.length];
            int j = 0;
            for (Coordinate coordinate : paramArrayOfCoordinate) {
                if (this.polygon.contains((Geometry)this.GF.createPoint(coordinate))) continue;
                arrayOfCoordinate1[j++] = coordinate;
            }
            Coordinate[] localObject = arrayOfCoordinate2 = CoordinateArrays.removeNull((Coordinate[])arrayOfCoordinate1);
            if (paramGeometry instanceof LinearRing && arrayOfCoordinate2.length > 1 && !arrayOfCoordinate2[arrayOfCoordinate2.length - 1].equals2D(arrayOfCoordinate2[0])) {
                Coordinate[] arrayOfCoordinate3 = new Coordinate[arrayOfCoordinate2.length + 1];
                CoordinateArrays.copyDeep((Coordinate[])arrayOfCoordinate2, (int)0, (Coordinate[])arrayOfCoordinate3, (int)0, (int)arrayOfCoordinate2.length);
                arrayOfCoordinate3[arrayOfCoordinate3.length - 1] = new Coordinate(arrayOfCoordinate3[0]);
                localObject = arrayOfCoordinate3;
            }
            return localObject;
        }
    }
}

