/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.gml2.GMLReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.xml.sax.SAXException;

public class ST_GeomFromGML
extends DeterministicScalarFunction {
    public static GeometryFactory gf;

    public ST_GeomFromGML() {
        this.addProperty("remarks", "Convert an input GML representation of geometry to a geometry.\n An optional argument is used to set a SRID.\nThis function supports only GML 2.1.2");
    }

    public String getJavaStaticMethod() {
        return "toGeometry";
    }

    public static Geometry toGeometry(String gmlFile) throws SAXException, IOException, ParserConfigurationException {
        return ST_GeomFromGML.toGeometry(gmlFile, 0);
    }

    public static Geometry toGeometry(String gmlFile, int srid) throws SAXException, IOException, ParserConfigurationException {
        if (gmlFile == null) {
            return null;
        }
        if (gf == null) {
            gf = new GeometryFactory(new PrecisionModel(), srid);
        }
        GMLReader gMLReader = new GMLReader();
        return gMLReader.read(gmlFile, gf);
    }
}

