/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.affine_transformations;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;

public class ZAffineTransformation
implements Cloneable,
CoordinateSequenceFilter {
    private final double m00;
    private final double m01;
    private final double m02;
    private final double m10;
    private final double m11;
    private final double m12;
    private final double m20;
    private final double m21;
    private final double m22;
    private final double m03;
    private final double m13;
    private final double m23;

    public ZAffineTransformation(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
    }

    public ZAffineTransformation(double dx, double dy, double dz) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = dx;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = dy;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = dz;
    }

    public void filter(CoordinateSequence seq, int i) {
        double x = seq.getOrdinate(i, 0);
        double y = seq.getOrdinate(i, 1);
        double z = seq.getOrdinate(i, 2);
        double xp = this.m00 * x + this.m01 * y + this.m02 * z + this.m03;
        double yp = this.m10 * x + this.m11 * y + this.m12 * z + this.m13;
        double zp = this.m20 * x + this.m21 * y + this.m22 * z + this.m23;
        seq.setOrdinate(i, 2, zp);
        seq.setOrdinate(i, 0, xp);
        seq.setOrdinate(i, 1, yp);
    }

    public boolean isDone() {
        return false;
    }

    public boolean isGeometryChanged() {
        return true;
    }
}

