/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.affine_transformations;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.h2gis.h2spatialext.function.spatial.affine_transformations.ZAffineTransformation;
import org.h2gis.utilities.jts_utils.CoordinateSequenceDimensionFilter;

public class ST_Translate
extends DeterministicScalarFunction {
    public static final String MIXED_DIM_ERROR = "Cannot translate geometries of mixed dimension";

    public ST_Translate() {
        this.addProperty("remarks", "Translates a geometry using X, Y (and possibly Z) offsets.");
    }

    public String getJavaStaticMethod() {
        return "translate";
    }

    public static Geometry translate(Geometry geom, double x, double y) {
        if (geom == null) {
            return null;
        }
        CoordinateSequenceDimensionFilter filter = new CoordinateSequenceDimensionFilter();
        geom.apply((CoordinateSequenceFilter)filter);
        ST_Translate.checkMixed(filter);
        return AffineTransformation.translationInstance((double)x, (double)y).transform(geom);
    }

    public static Geometry translate(Geometry geom, double x, double y, double z) {
        if (geom == null) {
            return null;
        }
        CoordinateSequenceDimensionFilter filter = new CoordinateSequenceDimensionFilter();
        geom.apply((CoordinateSequenceFilter)filter);
        ST_Translate.checkMixed(filter);
        if (filter.is2D()) {
            return AffineTransformation.translationInstance((double)x, (double)y).transform(geom);
        }
        Geometry clone = (Geometry)geom.clone();
        clone.apply((CoordinateSequenceFilter)new ZAffineTransformation(x, y, z));
        return clone;
    }

    private static void checkMixed(CoordinateSequenceDimensionFilter filter) {
        if (filter.isMixed()) {
            throw new IllegalArgumentException(MIXED_DIM_ERROR);
        }
    }
}

