/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.affine_transformations;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_Rotate
extends DeterministicScalarFunction {
    public ST_Rotate() {
        this.addProperty("remarks", "Rotates a geometry by a given angle (inradians) about the geometry's center.");
    }

    public String getJavaStaticMethod() {
        return "rotate";
    }

    public static Geometry rotate(Geometry geom, double theta) {
        Coordinate center = geom.getEnvelopeInternal().centre();
        return ST_Rotate.rotate(geom, theta, center.x, center.y);
    }

    public static Geometry rotate(Geometry geom, double theta, Point point) {
        return ST_Rotate.rotate(geom, theta, point.getX(), point.getY());
    }

    public static Geometry rotate(Geometry geom, double theta, double x0, double y0) {
        if (geom != null) {
            return AffineTransformation.rotationInstance((double)theta, (double)x0, (double)y0).transform(geom);
        }
        return null;
    }
}

