/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.wrapper;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.SpatialResultSetMetaData;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.wrapper.ResultSetMetaDataWrapper;
import org.h2gis.utilities.wrapper.StatementWrapper;

public class SpatialResultSetMetaDataImpl
extends ResultSetMetaDataWrapper
implements SpatialResultSetMetaData {
    private int firstGeometryFieldIndex = -1;

    public SpatialResultSetMetaDataImpl(ResultSetMetaData resultSetMetaData, StatementWrapper statement) {
        super(resultSetMetaData, statement);
    }

    @Override
    public int getFirstGeometryFieldIndex() throws SQLException {
        if (this.firstGeometryFieldIndex == -1) {
            for (int idColumn = 1; idColumn <= this.getColumnCount(); ++idColumn) {
                if (!this.getColumnTypeName(idColumn).equalsIgnoreCase("geometry")) continue;
                this.firstGeometryFieldIndex = idColumn;
                break;
            }
        }
        return this.firstGeometryFieldIndex;
    }

    @Override
    public int getGeometryType() throws SQLException {
        return this.getGeometryType(this.getFirstGeometryFieldIndex());
    }

    @Override
    public int getGeometryType(int column) throws SQLException {
        return SFSUtilities.getGeometryType(this.statement.getConnection(), new TableLocation(this.getCatalogName(column), this.getSchemaName(column), this.getTableName(column)), this.getColumnName(column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException ex) {
                throw new SQLException(ex);
            }
        }
        return super.unwrap(iface);
    }
}

