/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.tools.SimpleResultSet;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class TableUtilities {
    private TableUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFields(Connection connection, SimpleResultSet rs, TableLocation tableLocation) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        ResultSet columnsRs = meta.getColumns(tableLocation.getCatalog(null), tableLocation.getSchema(null), tableLocation.getTable(), null);
        HashMap<Integer, Object[]> columns = new HashMap<Integer, Object[]>();
        int COLUMN_NAME = 0;
        int COLUMN_TYPE = 1;
        int COLUMN_TYPENAME = 2;
        int COLUMN_PRECISION = 3;
        int COLUMN_SCALE = 4;
        try {
            while (columnsRs.next()) {
                Object[] columnInfoObjects = new Object[COLUMN_SCALE + 1];
                columnInfoObjects[COLUMN_NAME] = columnsRs.getString("COLUMN_NAME");
                columnInfoObjects[COLUMN_TYPE] = columnsRs.getInt("DATA_TYPE");
                columnInfoObjects[COLUMN_TYPENAME] = columnsRs.getString("TYPE_NAME");
                columnInfoObjects[COLUMN_PRECISION] = columnsRs.getInt("COLUMN_SIZE");
                columnInfoObjects[COLUMN_SCALE] = columnsRs.getInt("DECIMAL_DIGITS");
                columns.put(columnsRs.getInt("ORDINAL_POSITION"), columnInfoObjects);
            }
        }
        finally {
            columnsRs.close();
        }
        for (int i = 1; i <= columns.size(); ++i) {
            Object[] columnInfoObjects = (Object[])columns.get(i);
            rs.addColumn((String)columnInfoObjects[COLUMN_NAME], ((Integer)columnInfoObjects[COLUMN_TYPE]).intValue(), (String)columnInfoObjects[COLUMN_TYPENAME], ((Integer)columnInfoObjects[COLUMN_PRECISION]).intValue(), ((Integer)columnInfoObjects[COLUMN_SCALE]).intValue());
        }
    }

    public static boolean isColumnListConnection(Connection connection) throws SQLException {
        return connection.getMetaData().getURL().equals("jdbc:columnlist:connection");
    }

    public static TableLocation parseInputTable(Connection connection, String inputTable) throws SQLException {
        return TableLocation.parse(inputTable, JDBCUtilities.isH2DataBase(connection.getMetaData()));
    }

    public static TableLocation suffixTableLocation(TableLocation inputTable, String suffix) {
        return new TableLocation(inputTable.getCatalog(), inputTable.getSchema(), inputTable.getTable() + suffix);
    }
}

