/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.h2gis.utilities.URIUtilities;

public class JDBCUrlParser {
    private static final String URL_STARTS = "jdbc:";
    public static final String SPATIAL_DATASOURCE_ENDSWITH = "_spatial";

    private JDBCUrlParser() {
    }

    public static Properties parse(String jdbcUrl) throws IllegalArgumentException {
        String query;
        String path;
        if (!jdbcUrl.startsWith(URL_STARTS)) {
            throw new IllegalArgumentException("JDBC Url must start with jdbc:");
        }
        String driverAndURI = jdbcUrl.substring(URL_STARTS.length());
        String driver = driverAndURI.substring(0, driverAndURI.indexOf(58));
        Properties properties = new Properties();
        URI uri = URI.create(driverAndURI.substring(driverAndURI.indexOf(58) + 1));
        if (uri.getHost() != null) {
            properties.setProperty("serverName", uri.getHost());
        }
        if ((path = uri.getPath()) != null) {
            String[] paths = path.split(";");
            if (uri.getHost() != null && paths[0].startsWith("/")) {
                paths[0] = paths[0].substring(1);
            }
            properties.setProperty("databaseName", paths[0]);
            for (int id = 1; id < paths.length; ++id) {
                String[] option = paths[id].split("=");
                if (option.length != 2) continue;
                properties.setProperty(option[0], option[1]);
            }
        }
        if ((query = uri.getQuery()) != null) {
            try {
                for (Map.Entry<String, String> entry : URIUtilities.getQueryKeyValuePairs(uri).entrySet()) {
                    properties.setProperty(entry.getKey(), entry.getValue());
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("JDBC Url encoding error", ex);
            }
        }
        if (uri.getPort() != -1) {
            properties.setProperty("portNumber", String.valueOf(uri.getPort()));
        }
        if (uri.getScheme() != null && !"file".equalsIgnoreCase(uri.getScheme())) {
            properties.setProperty("networkProtocol", uri.getScheme());
        }
        return properties;
    }
}

