/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import java.util.ArrayList;
import java.util.List;
import org.cts.Identifier;
import org.cts.crs.GeodeticCRS;
import org.cts.datum.GeodeticDatum;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.transformation.NTv2GridShiftTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoordinateOperationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinateOperationFactory.class);
    public static final int GDATUM_OP = 1;
    public static final int VDATUM_OP = 2;
    public static final int ELLIPSOID_OP = 4;
    public static final int PRIME_MERIDIAN_OP = 8;
    public static final int GEOGRAPHIC_OP = 16;
    public static final int PROJECTION_OP = 32;
    public static final int DIMENSION_OP = 64;
    public static final int AXIS_ORDER_OP = 128;
    public static final int UNIT_OP = 256;

    public static List<CoordinateOperation> createCoordinateOperations(GeodeticCRS source, GeodeticCRS target) {
        if (source == null) {
            throw new IllegalArgumentException("The source CRS must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("The target CRS must not be null");
        }
        List<CoordinateOperation> opList = source.getCRSTransformations(target);
        if (opList != null) {
            return opList;
        }
        opList = new ArrayList<CoordinateOperation>();
        GeodeticDatum sourceDatum = source.getDatum();
        if (sourceDatum == null) {
            LOG.warn(source.getName() + " has no Geodetic Datum");
            throw new IllegalArgumentException("The source datum must not be null");
        }
        GeodeticDatum targetDatum = target.getDatum();
        if (targetDatum == null) {
            LOG.warn(target.getName() + " has no Geodetic Datum");
            throw new IllegalArgumentException("The target datum must not be null");
        }
        if (source.getGridTransformations(targetDatum) != null) {
            CoordinateOperationFactory.addNadgridsOperationDir(sourceDatum, source, targetDatum, target, source.getGridTransformations(targetDatum), opList);
        } else if (target.getGridTransformations(sourceDatum) != null) {
            CoordinateOperationFactory.addNadgridsOperationInv(sourceDatum, source, targetDatum, target, target.getGridTransformations(sourceDatum), opList);
        }
        if (sourceDatum.equals(targetDatum)) {
            CoordinateOperationFactory.addCoordinateOperations(sourceDatum, source, target, opList);
        } else {
            CoordinateOperationFactory.addCoordinateOperations(sourceDatum, source, targetDatum, target, opList);
        }
        source.addCRSTransformation(target, opList);
        return opList;
    }

    private static void addNadgridsOperationDir(GeodeticDatum sourceDatum, GeodeticCRS source, GeodeticDatum targetDatum, GeodeticCRS target, List<CoordinateOperation> nadgridsTransformations, List<CoordinateOperation> opList) {
        for (CoordinateOperation coordOp : nadgridsTransformations) {
            try {
                if (!(coordOp instanceof NTv2GridShiftTransformation) || sourceDatum.getShortName().equals(((NTv2GridShiftTransformation)coordOp).getFromDatum())) {
                    opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, source.getName() + " to " + target.getName()), source.toGeographicCoordinateConverter(), coordOp, target.fromGeographicCoordinateConverter()));
                    continue;
                }
                NTv2GridShiftTransformation gt = (NTv2GridShiftTransformation)coordOp;
                GeodeticDatum gtSource = GeodeticDatum.datumFromName.get(gt.getFromDatum());
                opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, sourceDatum.getName() + " to " + targetDatum.getName() + " through " + gt.getName() + " transformation"), source.toGeographicCoordinateConverter(), sourceDatum.getCoordinateOperations(gtSource).get(0), gt, target.fromGeographicCoordinateConverter()));
            }
            catch (NonInvertibleOperationException e) {
                LOG.warn("Operation from " + source.getName() + " to " + target.getName() + " could not be created");
                LOG.error("CoordinateOperationFactory", (Throwable)e);
            }
        }
    }

    private static void addNadgridsOperationInv(GeodeticDatum sourceDatum, GeodeticCRS source, GeodeticDatum targetDatum, GeodeticCRS target, List<CoordinateOperation> nadgridsTransformations, List<CoordinateOperation> opList) {
        for (CoordinateOperation coordOp : nadgridsTransformations) {
            try {
                if (!(coordOp instanceof NTv2GridShiftTransformation) || sourceDatum.getShortName().equals(((NTv2GridShiftTransformation)coordOp).getFromDatum())) {
                    opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, source.getName() + " to " + target.getName()), source.toGeographicCoordinateConverter(), coordOp.inverse(), target.fromGeographicCoordinateConverter()));
                    continue;
                }
                NTv2GridShiftTransformation gt = (NTv2GridShiftTransformation)coordOp;
                GeodeticDatum gtSource = GeodeticDatum.datumFromName.get(gt.getFromDatum());
                opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, source.getName() + " to " + target.getName()), source.toGeographicCoordinateConverter(), gt.inverse(), gtSource.getCoordinateOperations(targetDatum).get(0), target.fromGeographicCoordinateConverter()));
            }
            catch (NonInvertibleOperationException e) {
                LOG.warn("Operation from " + source.getName() + " to " + target.getName() + " could not be created");
                LOG.error("CoordinateOperationFactory", (Throwable)e);
            }
        }
    }

    private static void addCoordinateOperations(GeodeticDatum datum, GeodeticCRS source, GeodeticCRS target, List<CoordinateOperation> opList) {
        try {
            opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, source.getName() + " to " + target.getName()), source.toGeographicCoordinateConverter(), target.fromGeographicCoordinateConverter()));
        }
        catch (NonInvertibleOperationException e) {
            LOG.warn("Operation from " + source.getName() + " to " + target.getName() + " could not be created");
            LOG.error("CoordinateOperationFactory", (Throwable)e);
        }
    }

    private static void addCoordinateOperations(GeodeticDatum sourceDatum, GeodeticCRS source, GeodeticDatum targetDatum, GeodeticCRS target, List<CoordinateOperation> opList) {
        List<CoordinateOperation> datumTransformations = sourceDatum.getCoordinateOperations(targetDatum);
        for (CoordinateOperation datumTf : datumTransformations) {
            try {
                opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, source.getName() + " to " + target.getName() + " through " + datumTf.getName()), source.toGeographicCoordinateConverter(), datumTf, target.fromGeographicCoordinateConverter()));
            }
            catch (NonInvertibleOperationException e) {
                LOG.warn("Operation from " + source.getName() + " to " + target.getName() + " through " + datumTf.getName() + " could not be created");
                LOG.error("CoordinateOperationFactory", (Throwable)e);
            }
        }
    }
}

