/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import java.util.ArrayList;
import org.cts.Identifier;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.GeodeticDatum;
import org.cts.datum.PrimeMeridian;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.Geocentric2Geographic;
import org.cts.op.Geographic2Geocentric;
import org.cts.op.LongitudeRotation;
import org.cts.op.NonInvertibleOperationException;

public class GeocentricCRS
extends GeodeticCRS {
    public CoordinateReferenceSystem.Type getType() {
        return CoordinateReferenceSystem.Type.GEOCENTRIC;
    }

    public GeocentricCRS(Identifier identifier, GeodeticDatum datum, CoordinateSystem coordSys) {
        super(identifier, datum, coordSys);
    }

    public CoordinateOperation toGeographicCoordinateConverter() throws NonInvertibleOperationException {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        ops.add(new Geocentric2Geographic(this.getDatum().getEllipsoid()));
        if (!this.getDatum().getPrimeMeridian().equals(PrimeMeridian.GREENWICH)) {
            ops.add(LongitudeRotation.getLongitudeRotationTo(this.getDatum().getPrimeMeridian()));
        }
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public CoordinateOperation fromGeographicCoordinateConverter() throws NonInvertibleOperationException {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        if (!this.getDatum().getPrimeMeridian().equals(PrimeMeridian.GREENWICH)) {
            ops.add(LongitudeRotation.getLongitudeRotationFrom(this.getDatum().getPrimeMeridian()));
        }
        ops.add(new Geographic2Geocentric(this.getDatum().getEllipsoid()));
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("GEOCCS[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getDatum().toWKT());
        w.append(',');
        w.append(this.getDatum().getPrimeMeridian().toWKT());
        w.append(',');
        w.append(this.getCoordinateSystem().getUnit(0).toWKT());
        for (int i = 0; i < this.getCoordinateSystem().getDimension(); ++i) {
            w.append(',');
            w.append(this.getCoordinateSystem().getAxis(i).toWKT());
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }
}

