/*
 * Decompiled with CFR 0.152.
 */
package org.cts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.cts.CRSHelper;
import org.cts.Identifier;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.parser.prj.PrjParser;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;
import org.cts.registry.RegistryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSFactory {
    private RegistryManager registryManager = new RegistryManager();
    protected final CRSCache<String, CoordinateReferenceSystem> CRSPOOL = new CRSCache(10);

    public CoordinateReferenceSystem getCRS(String authorityAndSrid) throws CRSException {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.CRSPOOL.get(authorityAndSrid);
        if (crs == null) {
            try {
                String[] registryNameWithCode = this.splitRegistryNameAndCode(authorityAndSrid);
                if (this.isRegistrySupported(registryNameWithCode[0])) {
                    Registry registry = this.getRegistryManager().getRegistry(registryNameWithCode[0]);
                    Map<String, String> crsParameters = registry.getParameters(registryNameWithCode[1]);
                    if (crsParameters != null) {
                        crs = CRSHelper.createCoordinateReferenceSystem(new Identifier(registryNameWithCode[0], registryNameWithCode[1], crsParameters.remove("title")), crsParameters);
                    }
                    if (crs != null) {
                        this.CRSPOOL.put(authorityAndSrid, crs);
                    }
                }
            }
            catch (RegistryException ex) {
                throw new CRSException("Cannot create the CRS", ex);
            }
        }
        return crs;
    }

    public String[] splitRegistryNameAndCode(String authorityAndSrid) throws RegistryException {
        String[] registryAndCode = authorityAndSrid.split(":");
        if (registryAndCode.length == 2) {
            return registryAndCode;
        }
        throw new RegistryException("This registry pattern " + authorityAndSrid + " is not supported");
    }

    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    public boolean isRegistrySupported(String registryName) throws RegistryException {
        if (this.getRegistryManager().contains(registryName.toLowerCase())) {
            return true;
        }
        throw new RegistryException("This registry " + registryName + " is not supported");
    }

    public CoordinateReferenceSystem createFromPrj(String prjString) throws CRSException {
        PrjParser p = new PrjParser();
        Map<String, String> prjParameters = p.getParameters(prjString);
        String name = prjParameters.remove("name");
        String refname = prjParameters.remove("refname");
        if (refname != null) {
            String[] authorityNameWithKey = refname.split(":");
            return CRSHelper.createCoordinateReferenceSystem(new Identifier(authorityNameWithKey[0], authorityNameWithKey[1], name), prjParameters);
        }
        return CRSHelper.createCoordinateReferenceSystem(new Identifier(CoordinateReferenceSystem.class, name), prjParameters);
    }

    public CoordinateReferenceSystem createFromPrj(InputStream stream, Charset encoding) throws IOException, CRSException {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, encoding));
        StringBuilder b = new StringBuilder();
        while (r.ready()) {
            b.append(r.readLine());
        }
        return this.createFromPrj(b.toString());
    }

    public CoordinateReferenceSystem createFromPrj(InputStream stream) throws IOException, CRSException {
        return this.createFromPrj(stream, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createFromPrj(File file) throws IOException, CRSException {
        CoordinateReferenceSystem crs;
        FileInputStream i = null;
        try {
            i = new FileInputStream(file);
            crs = this.createFromPrj(i);
        }
        finally {
            if (i != null) {
                ((InputStream)i).close();
            }
        }
        return crs;
    }

    public Set<String> getSupportedCodes(String registryName) throws RegistryException {
        return this.getRegistryManager().getRegistry(registryName).getSupportedCodes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CRSCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int limit;

        public CRSCache(int limit) {
            super(16, 0.75f, true);
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.limit;
        }
    }
}

