/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.optaplanner.benchmark.impl.statistic.ConstraintSummary;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class StatisticRegistry<Solution_>
extends SimpleMeterRegistry
implements PhaseLifecycleListener<Solution_> {
    List<BiConsumer<Long, AbstractStepScope<Solution_>>> stepMeterListenerList = new ArrayList<BiConsumer<Long, AbstractStepScope<Solution_>>>();
    List<BiConsumer<Long, AbstractStepScope<Solution_>>> bestSolutionMeterListenerList = new ArrayList<BiConsumer<Long, AbstractStepScope<Solution_>>>();
    AbstractStepScope<Solution_> bestSolutionStepScope = null;
    long bestSolutionChangedTimestamp = Long.MIN_VALUE;
    boolean lastStepImprovedSolution = false;
    ScoreDefinition<?> scoreDefinition;
    final Function<Number, Number> scoreLevelNumberConverter;

    public StatisticRegistry(DefaultSolver<Solution_> solver) {
        this.scoreDefinition = solver.getSolverScope().getScoreDefinition();
        Number zeroScoreLevel0 = this.scoreDefinition.getZeroScore().toLevelNumbers()[0];
        if (zeroScoreLevel0 instanceof BigDecimal) {
            this.scoreLevelNumberConverter = number -> BigDecimal.valueOf(number.doubleValue());
        } else if (zeroScoreLevel0 instanceof BigInteger) {
            this.scoreLevelNumberConverter = number -> BigInteger.valueOf(number.longValue());
        } else if (zeroScoreLevel0 instanceof Double) {
            this.scoreLevelNumberConverter = Number::doubleValue;
        } else if (zeroScoreLevel0 instanceof Float) {
            this.scoreLevelNumberConverter = Number::floatValue;
        } else if (zeroScoreLevel0 instanceof Long) {
            this.scoreLevelNumberConverter = Number::longValue;
        } else if (zeroScoreLevel0 instanceof Integer) {
            this.scoreLevelNumberConverter = Number::intValue;
        } else if (zeroScoreLevel0 instanceof Short) {
            this.scoreLevelNumberConverter = Number::shortValue;
        } else if (zeroScoreLevel0 instanceof Byte) {
            this.scoreLevelNumberConverter = Number::byteValue;
        } else {
            throw new IllegalStateException("Cannot determine score level type for score definition (" + this.scoreDefinition.getClass().getName() + ").");
        }
    }

    public void addListener(SolverMetric metric, Consumer<Long> listener) {
        this.addListener(metric, (Long timestamp, AbstractStepScope<Solution_> stepScope) -> listener.accept((Long)timestamp));
    }

    public void addListener(SolverMetric metric, BiConsumer<Long, AbstractStepScope<Solution_>> listener) {
        if (metric.isMetricBestSolutionBased()) {
            this.bestSolutionMeterListenerList.add(listener);
        } else {
            this.stepMeterListenerList.add(listener);
        }
    }

    public Set<Meter.Id> getMeterIds(SolverMetric metric, Tags runId) {
        return Search.in((MeterRegistry)this).name(name -> name.startsWith(metric.getMeterId())).tags((Iterable)runId).meters().stream().map(Meter::getId).collect(Collectors.toSet());
    }

    public void extractScoreFromMeters(SolverMetric metric, Tags runId, Consumer<Score<?>> scoreConsumer) {
        String[] labelNames = this.scoreDefinition.getLevelLabels();
        for (int i = 0; i < labelNames.length; ++i) {
            labelNames[i] = labelNames[i].replace(' ', '.');
        }
        Number[] levelNumbers = new Number[labelNames.length];
        for (int i = 0; i < labelNames.length; ++i) {
            Gauge scoreLevelGauge = this.find(metric.getMeterId() + "." + labelNames[i]).tags((Iterable)runId).gauge();
            if (scoreLevelGauge == null || !Double.isFinite(scoreLevelGauge.value())) {
                return;
            }
            levelNumbers[i] = this.scoreLevelNumberConverter.apply(scoreLevelGauge.value());
        }
        scoreConsumer.accept(this.scoreDefinition.fromLevelNumbers(0, levelNumbers));
    }

    public void extractConstraintSummariesFromMeters(SolverMetric metric, Tags runId, Consumer<ConstraintSummary<?>> constraintMatchTotalConsumer) {
        Set<Meter.Id> meterIds = this.getMeterIds(metric, runId);
        HashSet constraintPackageNamePairs = new HashSet();
        meterIds.forEach(meterId -> constraintPackageNamePairs.add(ImmutablePair.of((Object)meterId.getTag("constraint.package"), (Object)meterId.getTag("constraint.name"))));
        constraintPackageNamePairs.forEach(constraintPackageNamePair -> {
            String constraintPackage = (String)constraintPackageNamePair.left;
            String constraintName = (String)constraintPackageNamePair.right;
            Tags constraintMatchTotalRunId = runId.and("constraint.package", constraintPackage).and("constraint.name", constraintName);
            this.extractScoreFromMeters(metric, constraintMatchTotalRunId, score -> this.getGaugeValue(metric.getMeterId() + ".count", constraintMatchTotalRunId, (Number count) -> constraintMatchTotalConsumer.accept(new ConstraintSummary<Score>(constraintPackage, constraintName, (Score)score, count.intValue()))));
        });
    }

    public void getGaugeValue(SolverMetric metric, Tags runId, Consumer<Number> gaugeConsumer) {
        this.getGaugeValue(metric.getMeterId(), runId, gaugeConsumer);
    }

    public void getGaugeValue(String meterId, Tags runId, Consumer<Number> gaugeConsumer) {
        Gauge gauge = this.find(meterId).tags((Iterable)runId).gauge();
        if (gauge != null && Double.isFinite(gauge.value())) {
            gaugeConsumer.accept(gauge.value());
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        long timestamp = System.currentTimeMillis() - stepScope.getPhaseScope().getSolverScope().getStartingSystemTimeMillis();
        this.stepMeterListenerList.forEach(listener -> listener.accept(timestamp, stepScope));
        if (stepScope.getBestScoreImproved().booleanValue()) {
            this.bestSolutionStepScope = stepScope;
            this.bestSolutionChangedTimestamp = timestamp;
            this.lastStepImprovedSolution = true;
        }
    }

    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
    }

    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        if (this.lastStepImprovedSolution) {
            this.bestSolutionMeterListenerList.forEach(listener -> listener.accept(this.bestSolutionChangedTimestamp, this.bestSolutionStepScope));
            this.lastStepImprovedSolution = false;
        }
    }

    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
    }

    public void solvingStarted(SolverScope<Solution_> solverScope) {
    }

    public void solvingEnded(SolverScope<Solution_> solverScope) {
        if (this.lastStepImprovedSolution) {
            this.bestSolutionMeterListenerList.forEach(listener -> listener.accept(this.bestSolutionChangedTimestamp, this.bestSolutionStepScope));
            this.lastStepImprovedSolution = false;
        }
    }
}

