/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.loader.ProblemProvider;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.ranking.TotalScoreSingleBenchmarkRankingComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.core.config.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="problemBenchmarkResult")
public class ProblemBenchmarkResult<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @XStreamOmitField
    private PlannerBenchmarkResult plannerBenchmarkResult;
    private String name = null;
    private ProblemProvider<Solution_> problemProvider;
    private boolean writeOutputSolutionEnabled = false;
    @XStreamImplicit(itemFieldName="problemStatistic")
    private List<ProblemStatistic> problemStatisticList = null;
    @XStreamImplicit(itemFieldName="singleBenchmarkResult")
    private List<SingleBenchmarkResult> singleBenchmarkResultList = null;
    private Long entityCount = null;
    private Long variableCount = null;
    private Long maximumValueCount = null;
    private Long problemScale = null;
    @XStreamOmitField
    private Integer maximumSubSingleCount = null;
    private Long averageUsedMemoryAfterInputSolution = null;
    private Integer failureCount = null;
    private SingleBenchmarkResult winningSingleBenchmarkResult = null;
    private SingleBenchmarkResult worstSingleBenchmarkResult = null;
    private Long worstScoreCalculationSpeed = null;

    public ProblemBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public void setPlannerBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProblemProvider<Solution_> getProblemProvider() {
        return this.problemProvider;
    }

    public void setProblemProvider(ProblemProvider<Solution_> problemProvider) {
        this.problemProvider = problemProvider;
    }

    public boolean isWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public List<ProblemStatistic> getProblemStatisticList() {
        return this.problemStatisticList;
    }

    public void setProblemStatisticList(List<ProblemStatistic> problemStatisticList) {
        this.problemStatisticList = problemStatisticList;
    }

    public List<SingleBenchmarkResult> getSingleBenchmarkResultList() {
        return this.singleBenchmarkResultList;
    }

    public void setSingleBenchmarkResultList(List<SingleBenchmarkResult> singleBenchmarkResultList) {
        this.singleBenchmarkResultList = singleBenchmarkResultList;
    }

    public Long getEntityCount() {
        return this.entityCount;
    }

    public Long getVariableCount() {
        return this.variableCount;
    }

    public Long getMaximumValueCount() {
        return this.maximumValueCount;
    }

    public Long getProblemScale() {
        return this.problemScale;
    }

    public Integer getMaximumSubSingleCount() {
        return this.maximumSubSingleCount;
    }

    public Long getAverageUsedMemoryAfterInputSolution() {
        return this.averageUsedMemoryAfterInputSolution;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public SingleBenchmarkResult getWinningSingleBenchmarkResult() {
        return this.winningSingleBenchmarkResult;
    }

    public SingleBenchmarkResult getWorstSingleBenchmarkResult() {
        return this.worstSingleBenchmarkResult;
    }

    public Long getWorstScoreCalculationSpeed() {
        return this.worstScoreCalculationSpeed;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.name);
    }

    public String findScoreLevelLabel(int scoreLevel) {
        String[] levelLabels = this.singleBenchmarkResultList.get(0).getSolverBenchmarkResult().getScoreDefinition().getLevelLabels();
        return levelLabels[scoreLevel];
    }

    public File getBenchmarkReportDirectory() {
        return this.plannerBenchmarkResult.getBenchmarkReportDirectory();
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }

    public boolean hasAnySuccess() {
        return this.singleBenchmarkResultList.size() - this.failureCount > 0;
    }

    public boolean hasAnyStatistic() {
        if (this.problemStatisticList.size() > 0) {
            return true;
        }
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (singleBenchmarkResult.getMedian().getPureSubSingleStatisticList().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasProblemStatisticType(ProblemStatisticType problemStatisticType) {
        for (ProblemStatistic problemStatistic : this.problemStatisticList) {
            if (problemStatistic.getProblemStatisticType() != problemStatisticType) continue;
            return true;
        }
        return false;
    }

    public Collection<SingleStatisticType> extractSingleStatisticTypeList() {
        LinkedHashSet<SingleStatisticType> singleStatisticTypeSet = new LinkedHashSet<SingleStatisticType>();
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            for (PureSubSingleStatistic pureSubSingleStatistic : singleBenchmarkResult.getMedian().getPureSubSingleStatisticList()) {
                singleStatisticTypeSet.add(pureSubSingleStatistic.getStatisticType());
            }
        }
        return singleStatisticTypeSet;
    }

    public List<PureSubSingleStatistic> extractPureSubSingleStatisticList(SingleStatisticType singleStatisticType) {
        ArrayList<PureSubSingleStatistic> pureSubSingleStatisticList = new ArrayList<PureSubSingleStatistic>(this.singleBenchmarkResultList.size());
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            for (PureSubSingleStatistic pureSubSingleStatistic : singleBenchmarkResult.getMedian().getPureSubSingleStatisticList()) {
                if (pureSubSingleStatistic.getStatisticType() != singleStatisticType) continue;
                pureSubSingleStatisticList.add(pureSubSingleStatistic);
            }
        }
        return pureSubSingleStatisticList;
    }

    public String getProblemReportDirectoryName() {
        return this.name;
    }

    public File getProblemReportDirectory() {
        return new File(this.getBenchmarkReportDirectory(), this.name);
    }

    public void makeDirs() {
        File problemReportDirectory = this.getProblemReportDirectory();
        problemReportDirectory.mkdirs();
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            singleBenchmarkResult.makeDirs();
        }
    }

    public int getTotalSubSingleCount() {
        int totalSubSingleCount = 0;
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            totalSubSingleCount += singleBenchmarkResult.getSubSingleCount();
        }
        return totalSubSingleCount;
    }

    public Solution_ readProblem() {
        return this.problemProvider.readProblem();
    }

    public void writeSolution(SubSingleBenchmarkResult subSingleBenchmarkResult, Solution_ solution) {
        if (!this.writeOutputSolutionEnabled) {
            return;
        }
        this.problemProvider.writeSolution(solution, subSingleBenchmarkResult);
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            singleBenchmarkResult.accumulateResults(benchmarkReport);
        }
        this.determineTotalsAndAveragesAndRanking();
        this.determineWinningScoreDifference();
        for (ProblemStatistic problemStatistic : this.problemStatisticList) {
            problemStatistic.accumulateResults(benchmarkReport);
        }
    }

    private void determineTotalsAndAveragesAndRanking() {
        this.failureCount = 0;
        this.maximumSubSingleCount = 0;
        this.worstScoreCalculationSpeed = null;
        long totalUsedMemoryAfterInputSolution = 0L;
        int usedMemoryAfterInputSolutionCount = 0;
        ArrayList<SingleBenchmarkResult> successResultList = new ArrayList<SingleBenchmarkResult>(this.singleBenchmarkResultList);
        Iterator it = successResultList.iterator();
        while (it.hasNext()) {
            SingleBenchmarkResult singleBenchmarkResult = (SingleBenchmarkResult)it.next();
            if (singleBenchmarkResult.hasAnyFailure()) {
                Integer n = this.failureCount;
                Integer n2 = this.failureCount = Integer.valueOf(this.failureCount + 1);
                it.remove();
                continue;
            }
            int subSingleCount = singleBenchmarkResult.getSubSingleBenchmarkResultList().size();
            if (subSingleCount > this.maximumSubSingleCount) {
                this.maximumSubSingleCount = subSingleCount;
            }
            if (singleBenchmarkResult.getUsedMemoryAfterInputSolution() != null) {
                totalUsedMemoryAfterInputSolution += singleBenchmarkResult.getUsedMemoryAfterInputSolution().longValue();
                ++usedMemoryAfterInputSolutionCount;
            }
            if (this.worstScoreCalculationSpeed != null && singleBenchmarkResult.getScoreCalculationSpeed() >= this.worstScoreCalculationSpeed) continue;
            this.worstScoreCalculationSpeed = singleBenchmarkResult.getScoreCalculationSpeed();
        }
        if (usedMemoryAfterInputSolutionCount > 0) {
            this.averageUsedMemoryAfterInputSolution = totalUsedMemoryAfterInputSolution / (long)usedMemoryAfterInputSolutionCount;
        }
        this.determineRanking(successResultList);
    }

    private void determineRanking(List<SingleBenchmarkResult> rankedSingleBenchmarkResultList) {
        TotalScoreSingleBenchmarkRankingComparator singleBenchmarkRankingComparator = new TotalScoreSingleBenchmarkRankingComparator();
        rankedSingleBenchmarkResultList.sort(Collections.reverseOrder(singleBenchmarkRankingComparator));
        int ranking = 0;
        SingleBenchmarkResult previousSingleBenchmarkResult = null;
        int previousSameRankingCount = 0;
        for (SingleBenchmarkResult singleBenchmarkResult : rankedSingleBenchmarkResultList) {
            if (previousSingleBenchmarkResult != null && singleBenchmarkRankingComparator.compare(previousSingleBenchmarkResult, singleBenchmarkResult) != 0) {
                ranking += previousSameRankingCount;
                previousSameRankingCount = 0;
            }
            singleBenchmarkResult.setRanking(ranking);
            previousSingleBenchmarkResult = singleBenchmarkResult;
            ++previousSameRankingCount;
        }
        this.winningSingleBenchmarkResult = rankedSingleBenchmarkResultList.isEmpty() ? null : rankedSingleBenchmarkResultList.get(0);
        this.worstSingleBenchmarkResult = rankedSingleBenchmarkResultList.isEmpty() ? null : rankedSingleBenchmarkResultList.get(rankedSingleBenchmarkResultList.size() - 1);
    }

    private void determineWinningScoreDifference() {
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (singleBenchmarkResult.hasAnyFailure()) continue;
            singleBenchmarkResult.setWinningScoreDifference(singleBenchmarkResult.getAverageScore().subtract(this.winningSingleBenchmarkResult.getAverageScore()));
            singleBenchmarkResult.setWorstScoreDifferencePercentage(ScoreDifferencePercentage.calculateScoreDifferencePercentage(this.worstSingleBenchmarkResult.getAverageScore(), singleBenchmarkResult.getAverageScore()));
            singleBenchmarkResult.setWorstScoreCalculationSpeedDifferencePercentage(ScoreDifferencePercentage.calculateDifferencePercentage(this.worstScoreCalculationSpeed.longValue(), singleBenchmarkResult.getScoreCalculationSpeed().longValue()));
        }
    }

    public void registerScale(long registeringEntityCount, long registeringVariableCount, long registeringMaximumValueCount, long registeringProblemScale) {
        if (this.entityCount == null) {
            this.entityCount = registeringEntityCount;
        } else if (this.entityCount != registeringEntityCount) {
            this.logger.warn("The problemBenchmarkResult ({}) has different entityCount values ([{},{}]).\nThis is normally impossible for 1 inputSolutionFile.", new Object[]{this.getName(), this.entityCount, registeringEntityCount});
            this.entityCount = -1L;
        }
        if (this.variableCount == null) {
            this.variableCount = registeringVariableCount;
        } else if (this.variableCount != registeringVariableCount) {
            this.logger.warn("The problemBenchmarkResult ({}) has different variableCount values ([{},{}]).\nThis is normally impossible for 1 inputSolutionFile.", new Object[]{this.getName(), this.variableCount, registeringVariableCount});
            this.variableCount = -1L;
        }
        if (this.maximumValueCount == null) {
            this.maximumValueCount = registeringMaximumValueCount;
        } else if (this.maximumValueCount != registeringMaximumValueCount) {
            this.logger.warn("The problemBenchmarkResult ({}) has different maximumValueCount values ([{},{}]).\nThis is normally impossible for 1 inputSolutionFile.", new Object[]{this.getName(), this.maximumValueCount, registeringMaximumValueCount});
            this.maximumValueCount = -1L;
        }
        if (this.problemScale == null) {
            this.problemScale = registeringProblemScale;
        } else if (this.problemScale != registeringProblemScale) {
            this.logger.warn("The problemBenchmarkResult ({}) has different problemScale values ([{},{}]).\nThis is normally impossible for 1 inputSolutionFile.", new Object[]{this.getName(), this.problemScale, registeringProblemScale});
            this.problemScale = -1L;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProblemBenchmarkResult) {
            ProblemBenchmarkResult other = (ProblemBenchmarkResult)o;
            return this.problemProvider.equals(other.getProblemProvider());
        }
        return false;
    }

    public int hashCode() {
        return this.problemProvider.hashCode();
    }

    protected static <Solution_> Map<ProblemBenchmarkResult, ProblemBenchmarkResult> createMergeMap(PlannerBenchmarkResult newPlannerBenchmarkResult, List<SingleBenchmarkResult> singleBenchmarkResultList) {
        IdentityHashMap<ProblemBenchmarkResult, ProblemBenchmarkResult> mergeMap = new IdentityHashMap<ProblemBenchmarkResult, ProblemBenchmarkResult>();
        HashMap<ProblemProvider<Solution_>, ProblemBenchmarkResult> problemProviderToNewResultMap = new HashMap<ProblemProvider<Solution_>, ProblemBenchmarkResult>();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            ProblemBenchmarkResult newResult;
            ProblemBenchmarkResult oldResult = singleBenchmarkResult.getProblemBenchmarkResult();
            if (mergeMap.containsKey(oldResult)) continue;
            if (!problemProviderToNewResultMap.containsKey(oldResult.problemProvider)) {
                newResult = new ProblemBenchmarkResult(newPlannerBenchmarkResult);
                newResult.name = oldResult.name;
                newResult.problemProvider = oldResult.problemProvider;
                newResult.problemStatisticList = new ArrayList<ProblemStatistic>(oldResult.problemStatisticList.size());
                for (ProblemStatistic oldProblemStatistic : oldResult.problemStatisticList) {
                    newResult.problemStatisticList.add(oldProblemStatistic.getProblemStatisticType().buildProblemStatistic(newResult));
                }
                newResult.singleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(oldResult.singleBenchmarkResultList.size());
                newResult.entityCount = oldResult.entityCount;
                newResult.variableCount = oldResult.variableCount;
                newResult.maximumValueCount = oldResult.maximumValueCount;
                newResult.problemScale = oldResult.problemScale;
                problemProviderToNewResultMap.put(oldResult.problemProvider, newResult);
                newPlannerBenchmarkResult.getUnifiedProblemBenchmarkResultList().add(newResult);
            } else {
                newResult = (ProblemBenchmarkResult)problemProviderToNewResultMap.get(oldResult.problemProvider);
                if (!Objects.equals(oldResult.name, newResult.name)) {
                    throw new IllegalStateException("The oldResult (" + oldResult + ") and newResult (" + newResult + ") should have the same name, because they have the same problemProvider (" + oldResult.problemProvider + ").");
                }
                newResult.problemStatisticList.removeIf(newStatistic -> !oldResult.hasProblemStatisticType(newStatistic.getProblemStatisticType()));
                newResult.entityCount = (Long)ConfigUtils.meldProperty((Object)oldResult.entityCount, (Object)newResult.entityCount);
                newResult.variableCount = (Long)ConfigUtils.meldProperty((Object)oldResult.variableCount, (Object)newResult.variableCount);
                newResult.maximumValueCount = (Long)ConfigUtils.meldProperty((Object)oldResult.maximumValueCount, (Object)newResult.maximumValueCount);
                newResult.problemScale = (Long)ConfigUtils.meldProperty((Object)oldResult.problemScale, (Object)newResult.problemScale);
            }
            mergeMap.put(oldResult, newResult);
        }
        return mergeMap;
    }

    public String toString() {
        return this.getName();
    }
}

