/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.tutorial.salesman;

import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.tutorial.salesman.SalesmanProblem;
import org.opt4j.tutorial.salesman.SalesmanRoute;

public class SalesmanEvaluator
implements Evaluator<SalesmanRoute> {
    public Objectives evaluate(SalesmanRoute salesmanRoute) {
        double dist = 0.0;
        for (int i = 0; i < salesmanRoute.size(); ++i) {
            SalesmanProblem.City one = (SalesmanProblem.City)salesmanRoute.get(i);
            SalesmanProblem.City two = (SalesmanProblem.City)salesmanRoute.get((i + 1) % salesmanRoute.size());
            dist += this.getEuclideanDistance(one, two);
        }
        Objectives objectives = new Objectives();
        objectives.add("distance", Objective.Sign.MIN, dist);
        return objectives;
    }

    private double getEuclideanDistance(SalesmanProblem.City one, SalesmanProblem.City two) {
        double x = one.getX() - two.getX();
        double y = one.getY() - two.getY();
        return Math.sqrt(x * x + y * y);
    }
}

