/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.tutorial.optimizer;

import com.google.inject.Inject;
import java.util.Collection;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.optimizer.IterativeOptimizer;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.operators.copy.Copy;
import org.opt4j.operators.mutate.Mutate;
import org.opt4j.optimizers.ea.Selector;

public class MutateOptimizer
implements IterativeOptimizer {
    protected final IndividualFactory individualFactory;
    protected final Mutate<Genotype> mutate;
    protected final Copy<Genotype> copy;
    protected final Selector selector;
    private final Population population;
    public static final int POPSIZE = 100;
    public static final int OFFSIZE = 25;

    @Inject
    public MutateOptimizer(Population population, IndividualFactory individualFactory, Selector selector, Mutate<Genotype> mutate, Copy<Genotype> copy) {
        this.individualFactory = individualFactory;
        this.mutate = mutate;
        this.copy = copy;
        this.selector = selector;
        this.population = population;
    }

    public void initialize() throws TerminationException {
        this.selector.init(125);
    }

    public void next() throws TerminationException {
        if (this.population.isEmpty()) {
            for (int i = 0; i < 100; ++i) {
                this.population.add(this.individualFactory.create());
            }
        } else {
            if (this.population.size() > 100) {
                Collection lames = this.selector.getLames(this.population.size() - 100, (Collection)this.population);
                this.population.removeAll(lames);
            }
            Collection parents = this.selector.getParents(25, (Collection)this.population);
            for (Individual parent : parents) {
                Genotype genotype = this.copy.copy(parent.getGenotype());
                this.mutate.mutate(genotype, 0.1);
                Individual child = this.individualFactory.create(genotype);
                this.population.add(child);
            }
        }
    }
}

