/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.satdecoding.sat4j;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opt4j.core.start.Constant;
import org.opt4j.satdecoding.Constraint;
import org.opt4j.satdecoding.ContradictionException;
import org.opt4j.satdecoding.Literal;
import org.opt4j.satdecoding.Model;
import org.opt4j.satdecoding.Order;
import org.opt4j.satdecoding.Solver;
import org.opt4j.satdecoding.TimeoutException;
import org.opt4j.satdecoding.VarOrder;
import org.opt4j.satdecoding.sat4j.VariableOrder;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.ClauseOnlyLearning;
import org.sat4j.minisat.learning.FixedLengthLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.orders.PositiveLiteralSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.ArminRestarts;
import org.sat4j.minisat.restarts.LubyRestarts;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.constraints.CompetResolutionPBMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverResolution;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

@Singleton
public class SAT4JSolver
implements Solver {
    protected final Queue<Constraint> constraints = new ConcurrentLinkedQueue<Constraint>();
    protected final PBSolverResolution solver;
    protected final Map<Object, Integer> variables = new HashMap<Object, Integer>();
    protected int nextVariable = 1;
    private boolean solverValid = false;

    @Inject
    public SAT4JSolver(@Constant(value="timeout", namespace=SAT4JSolver.class) int timeout, @Constant(value="clauseLearningLength", namespace=SAT4JSolver.class) int clauseLearningLength, @Constant(value="learning", namespace=SAT4JSolver.class) Learning learning, @Constant(value="restarts", namespace=SAT4JSolver.class) Restarts restarts) {
        MiniSATLearning l = null;
        switch (learning) {
            case FIXEDLENGTH: {
                if (clauseLearningLength < 0) {
                    throw new IllegalArgumentException("learning length must not be less than 0.");
                }
                l = new FixedLengthLearning(clauseLearningLength);
                break;
            }
            case MINISAT: {
                l = new MiniSATLearning();
                break;
            }
            case CLAUSEONLY: {
                l = new ClauseOnlyLearning();
                break;
            }
            default: {
                throw new IllegalArgumentException("Learning strategy not supported: " + (Object)((Object)learning));
            }
        }
        MiniSATRestarts r = null;
        switch (restarts) {
            case MINISAT: {
                r = new MiniSATRestarts();
                break;
            }
            case LUBY: {
                r = new LubyRestarts();
                break;
            }
            case RAPID: {
                r = new ArminRestarts();
                break;
            }
            default: {
                throw new IllegalArgumentException("Restart strategy not supported: " + (Object)((Object)restarts));
            }
        }
        this.solver = new PBSolverResolution((LearningStrategy)l, (PBDataStructureFactory)new CompetResolutionPBMixedHTClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap((IPhaseSelectionStrategy)new PositiveLiteralSelectionStrategy()), (RestartStrategy)r);
        l.setSolver((org.sat4j.minisat.core.Solver)this.solver);
        l.setVarActivityListener((VarActivityListener)this.solver);
        if (l instanceof MiniSATLearning) {
            l.setDataStructureFactory(this.solver.getDSFactory());
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.solver.setTimeout(timeout);
        this.solver.setVerbose(false);
        this.setNVars(100);
        this.solverValid = true;
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    @Override
    public synchronized Model solve(Order order) throws TimeoutException, ContradictionException {
        if (!this.solverValid) {
            throw new ContradictionException();
        }
        Constraint c = null;
        while ((c = this.constraints.poll()) != null) {
            this.addConstraintToSolver(c);
        }
        if (order instanceof VarOrder) {
            int var;
            VarOrder varOrder = (VarOrder)order;
            VariableOrder o = new VariableOrder();
            this.solver.setOrder((IOrder)o);
            for (Map.Entry<Object, Number> entry : varOrder.getActivityEntrySet()) {
                if (!this.variables.containsKey(entry.getKey())) continue;
                var = this.variables.get(entry.getKey());
                o.setVarActivity(var, (Double)entry.getValue());
            }
            for (Map.Entry<Object, Constable> entry : varOrder.getPhaseEntrySet()) {
                if (!this.variables.containsKey(entry.getKey())) continue;
                var = this.variables.get(entry.getKey());
                o.setVarPhase(var, (Boolean)entry.getValue());
            }
            o.setVarInc(varOrder.getVarInc());
            o.setVarDecay(varOrder.getVarDecay());
        }
        try {
            boolean success = this.solver.isSatisfiable();
            if (success) {
                Model model = new Model();
                for (Map.Entry<Object, Number> entry : this.variables.entrySet()) {
                    model.set(entry.getKey(), this.solver.model(((Integer)entry.getValue()).intValue()));
                }
                return model;
            }
            throw new ContradictionException();
        }
        catch (org.sat4j.specs.TimeoutException e) {
            throw new TimeoutException();
        }
    }

    protected void addConstraintToSolver(Constraint constraint) {
        VecInt lits = this.toVecInt(constraint.getLiterals());
        Vec coeffs = new Vec();
        for (Integer value : constraint.getCoefficients()) {
            coeffs.push((Object)BigInteger.valueOf(value.intValue()));
        }
        BigInteger d = BigInteger.valueOf(constraint.getRhs());
        Constraint.Operator operator = constraint.getOperator();
        try {
            if (operator == Constraint.Operator.LE || operator == Constraint.Operator.EQ) {
                this.solver.addPseudoBoolean((IVecInt)lits, (IVec)coeffs, false, d);
            }
            if (operator == Constraint.Operator.GE || operator == Constraint.Operator.EQ) {
                this.solver.addPseudoBoolean((IVecInt)lits, (IVec)coeffs, true, d);
            }
        }
        catch (org.sat4j.specs.ContradictionException e) {
            this.solverValid = false;
            throw new ContradictionException(e);
        }
    }

    protected VecInt toVecInt(Iterable<Literal> list) {
        VecInt vector = new VecInt();
        for (Literal literal : list) {
            Object var = literal.variable();
            if (!this.variables.containsKey(var)) {
                this.variables.put(var, this.nextVariable++);
                if (this.variables.size() > this.solver.nVars()) {
                    this.setNVars(this.variables.size() * 2);
                }
            }
            boolean phase = literal.phase();
            vector.push(this.variables.get(var) * (phase ? 1 : -1));
        }
        return vector;
    }

    protected void setNVars(int n) {
        this.solver.newVar(n);
    }

    public static enum Restarts {
        MINISAT,
        LUBY,
        RAPID;

    }

    public static enum Learning {
        FIXEDLENGTH,
        MINISAT,
        CLAUSEONLY;

    }
}

