/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.satdecoding;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.opt4j.core.start.Constant;
import org.opt4j.satdecoding.Constraint;
import org.opt4j.satdecoding.Model;
import org.opt4j.satdecoding.Order;
import org.opt4j.satdecoding.Solver;
import org.opt4j.satdecoding.TimeoutException;

public class PooledSolver
implements Solver {
    protected final Set<Solver> solvers = new HashSet<Solver>();
    protected final BlockingQueue<Solver> queue = new LinkedBlockingQueue<Solver>();

    @Inject
    public PooledSolver(@Constant(value="solver", namespace=PooledSolver.class) Provider<Solver> solverProvider, @Constant(value="instances", namespace=PooledSolver.class) int instances) {
        for (int i = 0; i < instances; ++i) {
            Solver solver = (Solver)solverProvider.get();
            this.solvers.add(solver);
            this.queue.add(solver);
        }
    }

    @Override
    public void addConstraint(Constraint constraint) {
        for (Solver solver : this.solvers) {
            solver.addConstraint(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model solve(Order order) throws TimeoutException {
        Solver solver = null;
        Model model = null;
        try {
            solver = this.queue.take();
            model = solver.solve(order);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (solver != null) {
                this.queue.offer(solver);
            }
        }
        return model;
    }
}

