/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.satdecoding;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.opt4j.core.Genotype;
import org.opt4j.core.genotype.BooleanGenotype;
import org.opt4j.core.genotype.BooleanMapGenotype;
import org.opt4j.core.genotype.Bounds;
import org.opt4j.core.genotype.DoubleBounds;
import org.opt4j.core.genotype.DoubleGenotype;
import org.opt4j.core.genotype.DoubleMapGenotype;
import org.opt4j.satdecoding.ContradictionException;
import org.opt4j.satdecoding.Model;
import org.opt4j.satdecoding.SATGenotype;
import org.opt4j.satdecoding.SATManager;
import org.opt4j.satdecoding.Solver;
import org.opt4j.satdecoding.TimeoutException;
import org.opt4j.satdecoding.VarOrder;

@Singleton
public class MixedSATManager
implements SATManager {
    protected final Solver solver;

    @Inject
    public MixedSATManager(Solver solver) {
        this.solver = solver;
    }

    @Override
    public Genotype createSATGenotype(List<Object> variables, Map<Object, Double> lowerBounds, Map<Object, Double> upperBounds, Map<Object, Double> priorities, Map<Object, Boolean> phases) {
        int size = variables.size();
        double[] lower = new double[size];
        double[] upper = new double[size];
        for (int i = 0; i < size; ++i) {
            Object variable = variables.get(i);
            Double lb = lowerBounds.get(variable);
            Double ub = upperBounds.get(variable);
            if (lb == null) {
                lb = 0.0;
            }
            if (ub == null) {
                ub = 1.0;
            }
            lower[i] = lb;
            upper[i] = ub;
        }
        DoubleBounds doubleBounds = new DoubleBounds(lower, upper);
        DoubleMapGenotype doubleVector = new DoubleMapGenotype(variables, (Bounds)doubleBounds);
        BooleanMapGenotype booleanVector = new BooleanMapGenotype(variables);
        SATGenotype satGenotype = new SATGenotype((BooleanGenotype)booleanVector, (DoubleGenotype)doubleVector);
        for (Object variable : variables) {
            double priority = priorities.get(variable);
            boolean phase = phases.get(variable);
            doubleVector.add((Object)priority);
            booleanVector.add((Object)phase);
        }
        return satGenotype;
    }

    @Override
    public Model decodeSATGenotype(List<Object> variables, Genotype genotype) {
        SATGenotype satGenotype = (SATGenotype)genotype;
        BooleanGenotype booleanVector = satGenotype.getBooleanVector();
        DoubleGenotype doubleVector = satGenotype.getDoubleVector();
        VarOrder varorder = new VarOrder();
        for (int i = 0; i < variables.size(); ++i) {
            Object var = variables.get(i);
            varorder.setActivity(var, (Double)doubleVector.get(i));
            varorder.setPhase(var, (Boolean)booleanVector.get(i));
        }
        varorder.setVarInc(1.0 / (2.0 * (double)variables.size()));
        varorder.setVarDecay(1.0526315789473684);
        Model model = null;
        try {
            model = this.solver.solve(varorder);
            if (model == null) {
                throw new ContradictionException("no satisfying solution left");
            }
        }
        catch (TimeoutException e) {
            System.err.println("timeout");
        }
        return model;
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }
}

