/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.sa;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.Objectives;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.Iteration;
import org.opt4j.core.optimizer.IterativeOptimizer;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.operators.copy.Copy;
import org.opt4j.operators.neighbor.Neighbor;
import org.opt4j.optimizers.sa.CoolingSchedule;

public class SimulatedAnnealing
implements IterativeOptimizer {
    protected final Random random;
    protected final Neighbor<Genotype> neighbor;
    protected final Copy<Genotype> copy;
    protected final CoolingSchedule coolingSchedule;
    private final IndividualFactory individualFactory;
    private final IndividualCompleter completer;
    private final Population population;
    private final Archive archive;
    private final Iteration iteration;
    private double fold;
    private Individual old;

    @Inject
    public SimulatedAnnealing(Population population, Archive archive, IndividualFactory individualFactory, IndividualCompleter completer, Rand random, Neighbor<Genotype> neighbor, Copy<Genotype> copy, CoolingSchedule coolingSchedule, Iteration iteration) {
        this.random = random;
        this.neighbor = neighbor;
        this.copy = copy;
        this.coolingSchedule = coolingSchedule;
        this.individualFactory = individualFactory;
        this.population = population;
        this.completer = completer;
        this.archive = archive;
        this.iteration = iteration;
    }

    public void initialize() throws TerminationException {
    }

    public void next() throws TerminationException {
        if (this.population.isEmpty()) {
            this.old = this.individualFactory.create();
            this.population.add(this.old);
            this.completer.complete((Iterable)this.population);
            this.fold = this.f(this.old);
        } else {
            Genotype g = this.copy.copy(this.old.getGenotype());
            this.neighbor.neighbor(g);
            Individual y = this.individualFactory.create(g);
            this.completer.complete(new Individual[]{y});
            this.archive.update(y);
            double fy = this.f(y);
            boolean sw = false;
            if (fy <= this.fold) {
                sw = true;
            } else {
                double a = (this.fold - fy) / this.coolingSchedule.getTemperature(this.iteration.value(), this.iteration.max());
                double e = Math.exp(a);
                if (this.random.nextDouble() < e) {
                    sw = true;
                }
            }
            if (sw) {
                this.population.remove((Object)this.old);
                this.population.add(y);
                this.fold = fy;
                this.old = y;
            }
        }
    }

    protected double f(Individual individual) {
        Objectives objectives = individual.getObjectives();
        double sum = 0.0;
        for (double d : objectives.array()) {
            sum += d;
        }
        return sum;
    }
}

