/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.mopso;

import com.google.inject.Inject;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.start.Constant;
import org.opt4j.operators.mutate.MutateDoubleElementwise;
import org.opt4j.operators.normalize.NormalizeDouble;
import org.opt4j.optimizers.mopso.MutateDoubleNonUniform;

public class MutateDoubleUniform
extends MutateDoubleElementwise {
    protected final double perturbation;

    @Inject
    public MutateDoubleUniform(Rand random, NormalizeDouble normalize, @Constant(value="perturbation", namespace=MutateDoubleNonUniform.class) double perturbation) {
        super(random, normalize);
        this.perturbation = perturbation;
    }

    protected double mutateElement(double x, double lb, double ub, double p) {
        if (this.random.nextDouble() < p) {
            double v = (this.random.nextDouble() - 0.5) * this.perturbation;
            x += v;
        }
        return x;
    }
}

