/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.start.Constant;
import org.opt4j.optimizers.ea.Selector;

public class Spea2
implements Selector {
    protected final Rand random;
    protected final int tournament;
    protected final Map<Individual, Spea2IndividualSet> map = new LinkedHashMap<Individual, Spea2IndividualSet>();
    protected final Set<Spea2IndividualSet> individualSets = new LinkedHashSet<Spea2IndividualSet>();
    protected final LinkedList<Integer> freeIDs = new LinkedList();
    protected double[][] distance;
    protected boolean fitnessDirty = true;

    @Inject
    public Spea2(@Constant(value="tournament", namespace=Spea2.class) int tournament, Rand random) {
        this.tournament = tournament;
        this.random = random;
    }

    @Override
    public void init(int maxsize) {
        for (int i = 0; i < maxsize; ++i) {
            this.freeIDs.add(i);
        }
        this.distance = new double[maxsize][maxsize];
    }

    @Override
    public Collection<Individual> getParents(int mu, Collection<Individual> population) {
        this.update(population);
        ArrayList<Individual> parents = new ArrayList<Individual>();
        ArrayList<Individual> candidates = new ArrayList<Individual>(population);
        int size = candidates.size();
        for (int i = 0; i < mu; ++i) {
            Individual winner = (Individual)candidates.get(this.random.nextInt(size));
            for (int j = 0; j < this.tournament; ++j) {
                double wDist;
                double oDist;
                double wFitness;
                Individual opponent = (Individual)candidates.get(this.random.nextInt(size));
                Spea2IndividualSet wWinner = this.map.get(winner);
                Spea2IndividualSet wOpponent = this.map.get(opponent);
                double oFitness = wWinner.getFitness();
                if (oFitness > (wFitness = (double)wOpponent.getFitness()) || winner == opponent) {
                    winner = opponent;
                    continue;
                }
                if (oFitness != wFitness || !((oDist = this.getMinDistance(wOpponent)) > (wDist = this.getMinDistance(wWinner)))) continue;
                winner = opponent;
            }
            parents.add(winner);
        }
        assert (parents.size() == mu);
        return parents;
    }

    @Override
    public Collection<Individual> getLames(int lambda, Collection<Individual> population) {
        this.update(population);
        assert (lambda <= population.size());
        LinkedHashSet<Individual> lames = new LinkedHashSet<Individual>();
        if (lambda > 0) {
            List<Spea2IndividualSet> dominated = this.getDominated();
            if (this.countIndividuals(dominated) >= lambda) {
                Collections.sort(dominated);
                ArrayList lameCandidates = new ArrayList();
                int i = 0;
                while (lameCandidates.size() < lambda) {
                    lameCandidates.addAll(dominated.get(i));
                    ++i;
                }
                lames.addAll(lameCandidates.subList(0, lambda));
            } else {
                for (Spea2IndividualSet w0 : dominated) {
                    lames.addAll(w0);
                }
                for (Individual individual : this.getLamesFromNonDominated(lambda - lames.size())) {
                    lames.add(individual);
                }
            }
        }
        assert (lames.size() == lambda);
        return lames;
    }

    public Collection<Individual> getLamesFromNonDominated(int count) {
        LinkedHashSet<Individual> set = new LinkedHashSet<Individual>();
        while (set.size() < count) {
            Individual individual;
            int maxsize = 0;
            ArrayList<Spea2IndividualSet> candidates = new ArrayList<Spea2IndividualSet>();
            for (Spea2IndividualSet individualSet : this.getNonDominated()) {
                if (individualSet.size() > maxsize) {
                    maxsize = individualSet.size();
                    candidates.clear();
                }
                if (individualSet.size() != maxsize) continue;
                candidates.add(individualSet);
            }
            if (candidates.size() <= count - set.size()) {
                for (Spea2IndividualSet individualSet : candidates) {
                    individual = individualSet.first();
                    this.remove(individual);
                    set.add(individual);
                }
                continue;
            }
            for (Spea2IndividualSet individualSet : this.getNearest(count - set.size(), candidates)) {
                individual = individualSet.first();
                this.remove(individual);
                set.add(individual);
            }
        }
        assert (set.size() == count);
        return set;
    }

    protected List<Spea2IndividualSet> getNearest(int n, Collection<Spea2IndividualSet> candidates) {
        assert (candidates.size() > n);
        ArrayList<Spea2IndividualSet> lames = new ArrayList<Spea2IndividualSet>();
        LinkedHashMap orderedLists = new LinkedHashMap();
        for (Spea2IndividualSet w0 : candidates) {
            ArrayList<Spea2IndividualSet> list = new ArrayList<Spea2IndividualSet>();
            for (Spea2IndividualSet w1 : candidates) {
                if (w0 == w1) continue;
                w1.setNextDistance(this.distance(w0, w1));
                list.add(w1);
            }
            Collections.sort(list, new Comparator<Spea2IndividualSet>(){

                @Override
                public int compare(Spea2IndividualSet o1, Spea2IndividualSet o2) {
                    double v = o1.getNextDistance() - o2.getNextDistance();
                    if (v < 0.0) {
                        return -1;
                    }
                    if (v > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            });
            orderedLists.put(w0, list);
        }
        while (lames.size() < n) {
            ArrayList lcandidates = new ArrayList(orderedLists.keySet());
            int size = lcandidates.size();
            for (int k = 0; k < size - 1; ++k) {
                double value;
                double min = Double.MAX_VALUE;
                for (Spea2IndividualSet candidate : lcandidates) {
                    value = this.distance(candidate, (Spea2IndividualSet)((List)orderedLists.get(candidate)).get(k));
                    min = Math.min(min, value);
                }
                Iterator it = lcandidates.iterator();
                while (it.hasNext()) {
                    Spea2IndividualSet candidate;
                    candidate = (Spea2IndividualSet)it.next();
                    value = this.distance(candidate, (Spea2IndividualSet)((List)orderedLists.get(candidate)).get(k));
                    if (!(value > min)) continue;
                    it.remove();
                }
                if (lcandidates.size() == 1) break;
            }
            Spea2IndividualSet lame = (Spea2IndividualSet)lcandidates.get(0);
            lames.add(lame);
            orderedLists.remove(lame);
            for (List list : orderedLists.values()) {
                list.remove(lame);
            }
        }
        assert (lames.size() == n);
        return lames;
    }

    protected double getMinDistance(Spea2IndividualSet w0) {
        double min = Double.MAX_VALUE;
        for (Spea2IndividualSet w1 : this.individualSets) {
            if (w0 == w1) continue;
            min = Math.min(min, this.distance(w0, w1));
        }
        return min;
    }

    protected void update(Collection<Individual> population) {
        LinkedHashSet<Individual> popSet = new LinkedHashSet<Individual>(population);
        if (!((Object)popSet).equals(this.map.keySet())) {
            LinkedHashSet<Individual> adds = new LinkedHashSet<Individual>(popSet);
            adds.removeAll(this.map.keySet());
            LinkedHashSet<Individual> removes = new LinkedHashSet<Individual>(this.map.keySet());
            removes.removeAll(popSet);
            for (Individual individual : removes) {
                this.remove(individual);
            }
            for (Individual individual : adds) {
                this.add(individual);
            }
        }
        assert (population.size() == this.map.size());
        if (this.fitnessDirty) {
            this.calculateFitness();
            this.fitnessDirty = false;
        }
    }

    protected double distance(Spea2IndividualSet w0, Spea2IndividualSet w1) {
        return this.distance[w0.getId()][w1.getId()];
    }

    protected void add(Individual individual) {
        int id0 = this.freeIDs.removeFirst();
        Spea2IndividualSet w0 = new Spea2IndividualSet(individual, id0);
        Spea2IndividualSet eq = null;
        for (Spea2IndividualSet w1 : this.individualSets) {
            int id1 = w1.getId();
            double dist = this.calculateDistance(w0, w1);
            if (dist == 0.0) {
                eq = w1;
                break;
            }
            this.distance[id0][id1] = dist;
            this.distance[id1][id0] = dist;
        }
        if (eq != null) {
            this.freeIDs.add(id0);
            w0 = eq;
            w0.add(individual);
        } else {
            this.distance[id0][id0] = 0.0;
            this.individualSets.add(w0);
        }
        this.map.put(individual, w0);
        this.fitnessDirty = true;
    }

    protected void remove(Individual individual) {
        Spea2IndividualSet individualSet = this.map.remove(individual);
        if (individualSet.size() == 1) {
            this.individualSets.remove(individualSet);
            this.freeIDs.add(individualSet.getId());
        } else {
            individualSet.remove(individual);
        }
        this.fitnessDirty = true;
    }

    protected double calculateDistance(Spea2IndividualSet w0, Spea2IndividualSet w1) {
        return w0.getObjectives().distance(w1.getObjectives());
    }

    protected void calculateFitness() {
        for (Spea2IndividualSet individual : this.individualSets) {
            int s = 0;
            for (Spea2IndividualSet other : this.individualSets) {
                if (individual == other || !individual.dominates(other)) continue;
                s += other.size();
            }
            individual.setStrength(s);
        }
        for (Spea2IndividualSet individual : this.individualSets) {
            int f = 0;
            for (Spea2IndividualSet other : this.individualSets) {
                if (individual == other || !other.dominates(individual)) continue;
                f += other.getStrength() * other.size();
            }
            individual.setFitness(f);
        }
    }

    protected List<Spea2IndividualSet> getDominated() {
        ArrayList<Spea2IndividualSet> dominated = new ArrayList<Spea2IndividualSet>();
        for (Spea2IndividualSet w0 : this.individualSets) {
            if (!((double)w0.getFitness() > 0.0)) continue;
            dominated.add(w0);
        }
        return dominated;
    }

    protected List<Spea2IndividualSet> getNonDominated() {
        ArrayList<Spea2IndividualSet> dominated = new ArrayList<Spea2IndividualSet>();
        for (Spea2IndividualSet w0 : this.individualSets) {
            if ((double)w0.getFitness() != 0.0) continue;
            dominated.add(w0);
        }
        return dominated;
    }

    private int countIndividuals(Collection<Spea2IndividualSet> collection) {
        int c = 0;
        for (Spea2IndividualSet w : collection) {
            c += w.size();
        }
        return c;
    }

    private static class Spea2IndividualSet
    extends LinkedHashSet<Individual>
    implements Comparable<Spea2IndividualSet> {
        private static final long serialVersionUID = 1L;
        protected final int id;
        protected int fitness;
        protected int strength;
        protected final Objectives objectives;
        protected double nextDistance = 0.0;

        Spea2IndividualSet(Individual individual, int id) {
            this.id = id;
            this.add(individual);
            this.objectives = individual.getObjectives();
            this.fitness = 0;
            this.strength = 0;
        }

        public Objectives getObjectives() {
            return this.objectives;
        }

        public int getFitness() {
            return this.fitness;
        }

        public void setFitness(int fitness) {
            this.fitness = fitness;
        }

        public int getStrength() {
            return this.strength;
        }

        public void setStrength(int strength) {
            this.strength = strength;
        }

        public Individual first() {
            assert (this.size() != 0);
            return (Individual)this.iterator().next();
        }

        public int getId() {
            return this.id;
        }

        public double getNextDistance() {
            return this.nextDistance;
        }

        public void setNextDistance(double nextDistance) {
            this.nextDistance = nextDistance;
        }

        @Override
        public int hashCode() {
            return this.id;
        }

        @Override
        public boolean equals(Object obj) {
            Spea2IndividualSet other = (Spea2IndividualSet)obj;
            return this.id == other.id;
        }

        public boolean dominates(Spea2IndividualSet individualSet) {
            return this.getObjectives().dominates(individualSet.getObjectives());
        }

        @Override
        public int compareTo(Spea2IndividualSet o) {
            return o.fitness - this.fitness;
        }
    }
}

