/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opt4j.core.Individual;
import org.opt4j.core.common.archive.FrontDensityIndicator;
import org.opt4j.core.start.Constant;

public class Hypervolume
implements FrontDensityIndicator {
    protected final double offset;

    @Inject
    public Hypervolume(@Constant(value="offset", namespace=Hypervolume.class) double offset) {
        this.offset = offset;
    }

    public Map<Individual, Double> getDensityValues(Collection<Individual> individuals) {
        return this.getDensityValues(individuals, this.offset);
    }

    protected Map<Individual, Double> getDensityValues(Collection<Individual> individuals, double offset) {
        if (individuals.isEmpty()) {
            throw new IllegalArgumentException("Individuals is empty.");
        }
        ArrayList<Individual> orderIndividuals = new ArrayList<Individual>(individuals);
        int m = individuals.iterator().next().getObjectives().size();
        if (m < 2) {
            HashMap<Individual, Double> result = new HashMap<Individual, Double>();
            for (Individual individual : individuals) {
                result.put(individual, 0.0);
            }
            return result;
        }
        if (m == 2) {
            return this.calculateHypervolumeContribution2D(orderIndividuals, offset);
        }
        return this.calculateHypervolumeContributionN(orderIndividuals, offset);
    }

    protected Map<Individual, Double> calculateHypervolumeContributionN(List<Individual> individuals, double offset) {
        HashMap<Individual, Double> result = new HashMap<Individual, Double>();
        List<double[]> front = this.invert(this.normalize(this.getMinValues(individuals)), offset);
        int m = front.get(0).length;
        double hvAll = this.calculateHypervolume(front, m);
        for (int i = 0; i < front.size(); ++i) {
            ArrayList<double[]> iFront = new ArrayList<double[]>(front);
            iFront.remove(i);
            double iHv = this.calculateHypervolume(iFront, m);
            result.put(individuals.get(i), hvAll - iHv);
        }
        return result;
    }

    protected Map<Individual, Double> calculateHypervolumeContribution2D(List<Individual> individuals, double offset) {
        HashMap<Individual, Double> result = new HashMap<Individual, Double>();
        List<double[]> front = this.invert(this.normalize(this.getMinValues(individuals)), offset);
        ArrayList<double[]> sorted = new ArrayList<double[]>(front);
        Collections.sort(sorted, new Comparator<double[]>(){

            @Override
            public int compare(double[] o1, double[] o2) {
                Double v1 = o1[0];
                Double v2 = o2[0];
                return v1.compareTo(v2);
            }
        });
        int size = sorted.size();
        for (int i = 0; i < size; ++i) {
            double diffX = ((double[])sorted.get(i))[0] - (i > 0 ? ((double[])sorted.get(i - 1))[0] : 0.0);
            double diffY = ((double[])sorted.get(i))[1] - (i < size - 1 ? ((double[])sorted.get(i + 1))[1] : 0.0);
            double contribution = diffX * diffY;
            result.put(individuals.get(front.indexOf(sorted.get(i))), contribution);
        }
        return result;
    }

    protected List<double[]> getMinValues(List<Individual> individuals) {
        ArrayList<double[]> minValues = new ArrayList<double[]>();
        for (Individual individual : individuals) {
            minValues.add(individual.getObjectives().array());
        }
        return minValues;
    }

    protected List<double[]> normalize(List<double[]> front) {
        int m = front.get(0).length;
        double[] min = new double[m];
        double[] max = new double[m];
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, -1.7976931348623157E308);
        for (double[] p : front) {
            for (int i = 0; i < m; ++i) {
                min[i] = Math.min(min[i], p[i]);
                max[i] = Math.max(max[i], p[i]);
            }
        }
        for (int i = 0; i < m; ++i) {
            if (min[i] != max[i]) continue;
            int n = i;
            max[n] = max[n] + 1.0;
        }
        ArrayList<double[]> normalized = new ArrayList<double[]>();
        for (double[] p : front) {
            double[] pn = new double[m];
            for (int i = 0; i < m; ++i) {
                pn[i] = (p[i] - min[i]) / (max[i] - min[i]);
            }
            normalized.add(pn);
        }
        return normalized;
    }

    protected List<double[]> invert(List<double[]> front, double offset) {
        int m = front.get(0).length;
        double[] nadir = new double[m];
        Arrays.fill(nadir, 1.0 + offset);
        ArrayList<double[]> inverted = new ArrayList<double[]>();
        for (double[] element : front) {
            double[] in = new double[element.length];
            for (int i = 0; i < element.length; ++i) {
                in[i] = nadir[i] - element[i];
            }
            inverted.add(in);
        }
        return inverted;
    }

    protected double calculateHypervolume(List<double[]> front, int nObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        while (!front.isEmpty()) {
            double tempVolume;
            List<double[]> nondominatedPoints = this.filterNondominatedSet(front, nObjectives - 1);
            if (nObjectives < 3) {
                assert (nondominatedPoints.size() > 0);
                tempVolume = nondominatedPoints.get(0)[0];
            } else {
                tempVolume = this.calculateHypervolume(nondominatedPoints, nObjectives - 1);
            }
            double tempDistance = this.surfaceUnchangedTo(front, nObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            front = this.reduceNondominatedSet(front, nObjectives - 1, distance);
        }
        return volume;
    }

    protected List<double[]> filterNondominatedSet(List<double[]> front, int nObjectives) {
        ArrayList<double[]> nondominated = new ArrayList<double[]>();
        for (double[] p1 : front) {
            boolean dominated = false;
            for (double[] p2 : nondominated) {
                if (!this.dominates(p2, p1, nObjectives)) continue;
                dominated = true;
                break;
            }
            if (dominated) continue;
            Iterator it = nondominated.iterator();
            while (it.hasNext()) {
                double[] p2;
                p2 = (double[])it.next();
                if (!this.dominates(p1, p2, nObjectives)) continue;
                it.remove();
            }
            nondominated.add(p1);
        }
        return nondominated;
    }

    protected boolean dominates(double[] p1, double[] p2, int nObjectives) {
        boolean strong = false;
        for (int i = 0; i < nObjectives; ++i) {
            if (p1[i] > p2[i]) {
                strong = true;
                continue;
            }
            if (!(p1[i] < p2[i])) continue;
            return false;
        }
        return strong;
    }

    protected double surfaceUnchangedTo(List<double[]> front, int objective) {
        assert (front.size() > 0);
        double value = Double.MAX_VALUE;
        for (double[] p : front) {
            value = Math.min(value, p[objective]);
        }
        return value;
    }

    protected List<double[]> reduceNondominatedSet(List<double[]> front, int objective, double threshold) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        for (double[] p : front) {
            if (!(p[objective] > threshold)) continue;
            result.add(p);
        }
        return result;
    }
}

