/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.ea;

import com.google.inject.Inject;
import java.util.Collection;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.IterativeOptimizer;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.start.Constant;
import org.opt4j.optimizers.ea.Mating;
import org.opt4j.optimizers.ea.Selector;

public class EvolutionaryAlgorithm
implements IterativeOptimizer {
    protected final int alpha;
    protected final int lambda;
    protected final int mu;
    protected final Selector selector;
    protected final Mating mating;
    private final IndividualFactory individualFactory;
    private final Population population;
    private final IndividualCompleter completer;

    @Inject
    public EvolutionaryAlgorithm(Population population, IndividualFactory individualFactory, IndividualCompleter completer, Selector selector, Mating mating, @Constant(value="alpha", namespace=EvolutionaryAlgorithm.class) int alpha, @Constant(value="mu", namespace=EvolutionaryAlgorithm.class) int mu, @Constant(value="lambda", namespace=EvolutionaryAlgorithm.class) int lambda) {
        this.selector = selector;
        this.mating = mating;
        this.alpha = alpha;
        this.mu = mu;
        this.lambda = lambda;
        this.individualFactory = individualFactory;
        this.population = population;
        this.completer = completer;
        if (alpha <= 0) {
            throw new IllegalArgumentException("Invalid alpha: " + alpha);
        }
        if (mu <= 0) {
            throw new IllegalArgumentException("Invalid mu: " + mu);
        }
        if (lambda <= 0) {
            throw new IllegalArgumentException("Invalid lambda: " + lambda);
        }
    }

    public void initialize() {
        this.selector.init(this.alpha + this.lambda);
    }

    public void next() throws TerminationException {
        int offspringCount;
        if (this.population.size() > this.alpha) {
            Collection<Individual> lames = this.selector.getLames(this.population.size() - this.alpha, (Collection<Individual>)this.population);
            this.population.removeAll(lames);
        }
        for (offspringCount = this.lambda; this.population.size() < this.alpha && offspringCount > 0; --offspringCount) {
            this.population.add(this.individualFactory.create());
        }
        if (offspringCount > 0) {
            if (offspringCount < this.lambda) {
                this.completer.complete((Iterable)this.population);
            }
            Collection<Individual> parents = this.selector.getParents(this.mu, (Collection<Individual>)this.population);
            Collection<Individual> offspring = this.mating.getOffspring(offspringCount, parents);
            this.population.addAll(offspring);
        }
    }
}

