/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.opt4j.core.Individual;
import org.opt4j.core.common.random.Rand;
import org.opt4j.optimizers.ea.Selector;

public class ElitismSelector
implements Selector {
    protected final Random random;
    protected final Map<Individual, Double> fitness = new HashMap<Individual, Double>();

    @Inject
    public ElitismSelector(Rand random) {
        this.random = random;
    }

    @Override
    public Collection<Individual> getLames(int lambda, Collection<Individual> population) {
        ArrayList<Individual> list = new ArrayList<Individual>(population);
        this.calculateFitness(list);
        Collections.sort(list, new FitnessComparator());
        Collections.reverse(list);
        ArrayList<Individual> lames = new ArrayList<Individual>();
        for (int i = 0; i < lambda; ++i) {
            lames.add((Individual)list.get(i));
        }
        return lames;
    }

    @Override
    public Collection<Individual> getParents(int mu, Collection<Individual> population) {
        ArrayList<Individual> parents = new ArrayList<Individual>();
        ArrayList<Individual> individuals = new ArrayList<Individual>(population);
        for (int i = 0; i < mu; ++i) {
            int r = this.random.nextInt(individuals.size());
            parents.add((Individual)individuals.get(r));
        }
        return parents;
    }

    protected void calculateFitness(Collection<Individual> individuals) {
        this.fitness.clear();
        for (Individual individual : individuals) {
            double f = 0.0;
            for (double v : individual.getObjectives().array()) {
                f += v;
            }
            this.fitness.put(individual, f);
        }
    }

    @Override
    public void init(int maxsize) {
    }

    protected class FitnessComparator
    implements Comparator<Individual> {
        protected FitnessComparator() {
        }

        @Override
        public int compare(Individual o1, Individual o2) {
            double f2;
            double f1 = ElitismSelector.this.fitness.get(o1);
            if (f1 < (f2 = ElitismSelector.this.fitness.get(o2).doubleValue())) {
                return -1;
            }
            if (f2 < f1) {
                return 1;
            }
            return 0;
        }
    }
}

