/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.de;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.DoubleGenotype;
import org.opt4j.core.optimizer.IncompatibilityException;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.IterativeOptimizer;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.start.Constant;
import org.opt4j.operators.algebra.Add;
import org.opt4j.operators.algebra.Algebra;
import org.opt4j.operators.algebra.Index;
import org.opt4j.operators.algebra.Mult;
import org.opt4j.operators.algebra.Sub;
import org.opt4j.operators.algebra.Term;
import org.opt4j.operators.algebra.Var;
import org.opt4j.operators.crossover.Crossover;
import org.opt4j.operators.crossover.Pair;
import org.opt4j.optimizers.ea.Selector;

public class DifferentialEvolution
implements IterativeOptimizer {
    protected final double scalingFactor;
    protected final int alpha;
    protected final Algebra<Genotype> algebra;
    protected final Crossover<Genotype> crossover;
    protected final Selector selector;
    protected final Random random;
    private final IndividualFactory individualFactory;
    private final Population population;
    private final IndividualCompleter completer;
    private Term term;

    @Inject
    public DifferentialEvolution(Population population, IndividualFactory individualFactory, IndividualCompleter completer, Algebra<Genotype> algebra, Selector selector, Rand random, Crossover<Genotype> crossover, @Constant(value="alpha", namespace=DifferentialEvolution.class) int alpha, @Constant(value="scalingFactor", namespace=DifferentialEvolution.class) double scalingFactor) {
        this.algebra = algebra;
        this.selector = selector;
        this.random = random;
        this.crossover = crossover;
        this.alpha = alpha;
        this.scalingFactor = scalingFactor;
        this.individualFactory = individualFactory;
        this.population = population;
        this.completer = completer;
    }

    public void initialize() {
        Index i0 = new Index(0);
        Index i1 = new Index(1);
        Index i2 = new Index(2);
        Var c = new Var(this.scalingFactor);
        this.term = new Add(new Term[]{i0, new Mult(new Term[]{c, new Sub((Term)i1, (Term)i2)})});
        this.selector.init(2 * this.alpha);
    }

    public void next() throws TerminationException {
        if (this.population.isEmpty()) {
            this.firstIterationNext();
        } else {
            this.followingIterationsNext();
        }
    }

    private void firstIterationNext() {
        while (this.population.size() < this.alpha) {
            Individual individual = this.individualFactory.create();
            Genotype genotype = individual.getGenotype();
            if (!(genotype instanceof DoubleGenotype)) {
                throw new IncompatibilityException("DifferentialEvolution is restricted to " + DoubleGenotype.class + ", current Genotype is: " + genotype.getClass());
            }
            this.population.add(individual);
        }
    }

    private void followingIterationsNext() throws TerminationException {
        HashMap<Individual, Individual> relation = new HashMap<Individual, Individual>();
        ArrayList<Individual> list = new ArrayList<Individual>((Collection<Individual>)this.population);
        for (Individual parent : this.population) {
            Individual offspring = this.createOffspring(parent, list, this.term);
            relation.put(parent, offspring);
        }
        this.population.addAll(relation.values());
        this.completer.complete((Iterable)this.population);
        for (Map.Entry entry : relation.entrySet()) {
            Individual parent = (Individual)entry.getKey();
            Individual offspring = (Individual)entry.getValue();
            if (!parent.getObjectives().weaklyDominates(offspring.getObjectives())) continue;
            this.population.remove((Object)offspring);
        }
        Collection<Individual> lames = this.selector.getLames(this.population.size() - this.alpha, (Collection<Individual>)this.population);
        this.population.removeAll(lames);
    }

    protected Individual createOffspring(Individual parent, List<Individual> individuals, Term term) {
        Triple triple = this.getTriple(parent, individuals);
        Genotype g0 = triple.getFirst().getGenotype();
        Genotype g1 = triple.getSecond().getGenotype();
        Genotype g2 = triple.getThird().getGenotype();
        Genotype result = this.algebra.algebra(term, new Genotype[]{g0, g1, g2});
        Pair g = this.crossover.crossover(result, parent.getGenotype());
        Individual i = this.random.nextBoolean() ? this.individualFactory.create((Genotype)g.getFirst()) : this.individualFactory.create((Genotype)g.getSecond());
        return i;
    }

    protected Triple getTriple(Individual parent, List<Individual> individuals) {
        individuals.remove(parent);
        Individual ind0 = individuals.remove(this.random.nextInt(individuals.size()));
        Individual ind1 = individuals.remove(this.random.nextInt(individuals.size()));
        Individual ind2 = individuals.remove(this.random.nextInt(individuals.size()));
        Triple triple = new Triple(ind0, ind1, ind2);
        individuals.add(parent);
        individuals.add(ind0);
        individuals.add(ind1);
        individuals.add(ind2);
        return triple;
    }

    protected static class Triple {
        protected final Individual first;
        protected final Individual second;
        protected final Individual third;

        public Triple(Individual first, Individual second, Individual third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public Individual getFirst() {
            return this.first;
        }

        public Individual getSecond() {
            return this.second;
        }

        public Individual getThird() {
            return this.third;
        }
    }
}

