/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.neighbor;

import org.opt4j.core.config.annotations.Info;
import org.opt4j.operators.neighbor.NeighborModule;
import org.opt4j.operators.neighbor.NeighborPermutation;
import org.opt4j.operators.neighbor.NeighborPermutationInsert;
import org.opt4j.operators.neighbor.NeighborPermutationMixed;
import org.opt4j.operators.neighbor.NeighborPermutationRevert;
import org.opt4j.operators.neighbor.NeighborPermutationSwap;

@Info(value="Setting for the basic neighbor classOperators for genotype variation.")
public class BasicNeighborModule
extends NeighborModule {
    @Info(value="The type of the neighbor operator for the Permutation genotype.")
    protected PermutationType permutationType = PermutationType.MIXED;

    public PermutationType getPermutationType() {
        return this.permutationType;
    }

    public void setPermutationType(PermutationType permutationMode) {
        this.permutationType = permutationMode;
    }

    public void config() {
        Class permutation = NeighborPermutationMixed.class;
        switch (this.permutationType) {
            case MIXED: {
                permutation = NeighborPermutationMixed.class;
                break;
            }
            case SWAP: {
                permutation = NeighborPermutationSwap.class;
                break;
            }
            case INSERT: {
                permutation = NeighborPermutationInsert.class;
                break;
            }
            case REVERT: {
                permutation = NeighborPermutationRevert.class;
            }
        }
        this.bind(NeighborPermutation.class).to(permutation).in(SINGLETON);
    }

    public static enum PermutationType {
        MIXED,
        SWAP,
        INSERT,
        REVERT;

    }
}

