/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.mutate;

import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.config.annotations.Required;
import org.opt4j.core.start.Constant;
import org.opt4j.operators.mutate.AdaptiveMutationRate;
import org.opt4j.operators.mutate.ConstantMutationRate;
import org.opt4j.operators.mutate.MutateDouble;
import org.opt4j.operators.mutate.MutateDoubleGauss;
import org.opt4j.operators.mutate.MutateDoublePolynomial;
import org.opt4j.operators.mutate.MutateModule;
import org.opt4j.operators.mutate.MutatePermutation;
import org.opt4j.operators.mutate.MutatePermutationInsert;
import org.opt4j.operators.mutate.MutatePermutationMixed;
import org.opt4j.operators.mutate.MutatePermutationRevert;
import org.opt4j.operators.mutate.MutatePermutationSwap;
import org.opt4j.operators.mutate.MutationRate;

@Info(value="Setting for the basic mutate classOperators for genotype variation.")
public class BasicMutateModule
extends MutateModule {
    @Info(value="The type of mutation rate.")
    protected MutationRateType mutationRateType = MutationRateType.ADAPTIVE;
    @Info(value="The type of the mutate operator for the Permutation genotype.")
    protected PermutationType permutationType = PermutationType.MIXED;
    @Info(value="The type of the mutate operator for the Double genotype.")
    protected DoubleType doubleType = DoubleType.POLYNOMIAL;
    @Required(property="doubleType", elements={"POLYNOMIAL"})
    @Constant(value="eta", namespace=MutateDoublePolynomial.class)
    protected double eta = 20.0;
    @Required(property="doubleType", elements={"GAUSS"})
    @Constant(value="sigma", namespace=MutateDoubleGauss.class)
    protected double sigma = 0.1;
    @Required(property="mutationRateType", elements={"CONSTANT"})
    @Constant(value="rate", namespace=ConstantMutationRate.class)
    protected double mutationRate = 0.01;

    public MutationRateType getMutationRateType() {
        return this.mutationRateType;
    }

    public void setMutationRateType(MutationRateType mutationRateType) {
        this.mutationRateType = mutationRateType;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public void setMutationRate(double mutationRate) {
        this.mutationRate = mutationRate;
    }

    public PermutationType getPermutationType() {
        return this.permutationType;
    }

    public void setPermutationType(PermutationType permutationMode) {
        this.permutationType = permutationMode;
    }

    public DoubleType getDoubleType() {
        return this.doubleType;
    }

    public void setDoubleType(DoubleType doubleType) {
        this.doubleType = doubleType;
    }

    public double getEta() {
        return this.eta;
    }

    public void setEta(double eta) {
        this.eta = eta;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public void config() {
        switch (this.mutationRateType) {
            case ADAPTIVE: {
                this.bind(MutationRate.class).to(AdaptiveMutationRate.class).in(SINGLETON);
                break;
            }
            case CONSTANT: {
                this.bind(MutationRate.class).to(ConstantMutationRate.class).in(SINGLETON);
            }
        }
        Class permutation = MutatePermutationMixed.class;
        switch (this.permutationType) {
            case MIXED: {
                permutation = MutatePermutationMixed.class;
                break;
            }
            case SWAP: {
                permutation = MutatePermutationSwap.class;
                break;
            }
            case INSERT: {
                permutation = MutatePermutationInsert.class;
                break;
            }
            case REVERT: {
                permutation = MutatePermutationRevert.class;
            }
        }
        this.bind(MutatePermutation.class).to(permutation).in(SINGLETON);
        switch (this.doubleType) {
            case GAUSS: {
                this.bind(MutateDouble.class).to(MutateDoubleGauss.class).in(SINGLETON);
                break;
            }
            case POLYNOMIAL: {
                this.bind(MutateDouble.class).to(MutateDoublePolynomial.class).in(SINGLETON);
            }
        }
    }

    public static enum PermutationType {
        MIXED,
        SWAP,
        INSERT,
        REVERT;

    }

    public static enum DoubleType {
        GAUSS,
        POLYNOMIAL;

    }

    public static enum MutationRateType {
        CONSTANT,
        ADAPTIVE;

    }
}

