/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.diversity;

import org.opt4j.core.config.annotations.Ignore;
import org.opt4j.core.config.annotations.Info;
import org.opt4j.operators.diversity.DiversityBoolean;
import org.opt4j.operators.diversity.DiversityBooleanFraction;
import org.opt4j.operators.diversity.DiversityDouble;
import org.opt4j.operators.diversity.DiversityDoubleAbsolute;
import org.opt4j.operators.diversity.DiversityDoubleEuclidean;
import org.opt4j.operators.diversity.DiversityModule;

@Info(value="Setting for the basic diversity classOperators for genotypes.")
public class BasicDiversityModule
extends DiversityModule {
    @Ignore
    @Info(value="The type of the diversity operator for the Boolean genotype.")
    BooleanType booleanType = BooleanType.FRACTION;
    @Info(value="The type of the diversity operator for the Double genotype.")
    DoubleType doubleType = DoubleType.ABSOLUTE;

    public BooleanType getBooleanType() {
        return this.booleanType;
    }

    public void setBooleanType(BooleanType booleanType) {
        this.booleanType = booleanType;
    }

    public DoubleType getDoubleType() {
        return this.doubleType;
    }

    public void setDoubleType(DoubleType doubleType) {
        this.doubleType = doubleType;
    }

    public void config() {
        switch (this.booleanType) {
            case FRACTION: {
                this.bind(DiversityBoolean.class).to(DiversityBooleanFraction.class).in(SINGLETON);
            }
        }
        switch (this.doubleType) {
            case ABSOLUTE: {
                this.bind(DiversityDouble.class).to(DiversityDoubleAbsolute.class).in(SINGLETON);
                break;
            }
            case EUCLIDEAN: {
                this.bind(DiversityDouble.class).to(DiversityDoubleEuclidean.class).in(SINGLETON);
            }
        }
    }

    public static enum DoubleType {
        ABSOLUTE,
        EUCLIDEAN;

    }

    public static enum BooleanType {
        FRACTION;

    }
}

