/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.crossover;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Random;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.PermutationGenotype;
import org.opt4j.core.start.Constant;
import org.opt4j.operators.crossover.CrossoverPermutation;
import org.opt4j.operators.crossover.Pair;

public class CrossoverPermutationOnePoint
implements CrossoverPermutation {
    protected final Random random;
    protected final boolean rotation;

    @Inject
    public CrossoverPermutationOnePoint(Rand random, @Constant(value="rotation", namespace=CrossoverPermutationOnePoint.class) boolean rotation) {
        this.random = random;
        this.rotation = rotation;
    }

    @Override
    public Pair<PermutationGenotype<?>> crossover(PermutationGenotype<?> p1, PermutationGenotype<?> p2) {
        PermutationGenotype o1 = (PermutationGenotype)p1.newInstance();
        PermutationGenotype o2 = (PermutationGenotype)p1.newInstance();
        int size = p1.size();
        assert (size == p2.size()) : "Permutation is undefined for genotypes with different lengths.";
        assert (p1.containsAll(p2)) : "Permutation is undefined for different domains.";
        if (size > 0) {
            Object e2;
            Object e1;
            int pos;
            int i;
            HashSet<Object> elements1 = new HashSet<Object>();
            HashSet<Object> elements2 = new HashSet<Object>();
            int offset = this.rotation ? this.random.nextInt(size) : 0;
            int cutpoint = this.random.nextInt(size);
            for (i = 0; i < cutpoint; ++i) {
                pos = (offset + i) % size;
                e1 = p1.get(pos);
                e2 = p2.get(pos);
                o1.add(e1);
                o2.add(e2);
                elements1.add(e1);
                elements2.add(e2);
            }
            offset = this.rotation ? this.random.nextInt(size) : 0;
            for (i = 0; i < size; ++i) {
                pos = (offset + i) % size;
                e1 = p1.get(pos);
                e2 = p2.get(pos);
                if (!elements1.contains(e2)) {
                    o1.add(e2);
                }
                if (elements2.contains(e1)) continue;
                o2.add(e1);
            }
        }
        Pair offspring = new Pair(o1, o2);
        return offspring;
    }
}

