/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.crossover;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.ListGenotype;
import org.opt4j.operators.crossover.Crossover;
import org.opt4j.operators.crossover.Pair;

public abstract class CrossoverListRate<G extends ListGenotype<?>>
implements Crossover<G> {
    protected final Random random;
    protected final double rate;

    @Inject
    public CrossoverListRate(double rate, Rand random) {
        this.rate = rate;
        this.random = random;
    }

    @Override
    public Pair<G> crossover(G p1, G p2) {
        ListGenotype o1 = (ListGenotype)p1.newInstance();
        ListGenotype o2 = (ListGenotype)p2.newInstance();
        int size = p1.size();
        boolean select = this.random.nextBoolean();
        for (int i = 0; i < size; ++i) {
            if (this.random.nextDouble() < this.rate) {
                boolean bl = select = !select;
            }
            if (select) {
                o1.add(p1.get(i));
                o2.add(p2.get(i));
                continue;
            }
            o1.add(p2.get(i));
            o2.add(p1.get(i));
        }
        Pair<ListGenotype> offspring = new Pair<ListGenotype>(o1, o2);
        return offspring;
    }
}

