/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.crossover;

import com.google.inject.Inject;
import java.util.List;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.start.Constant;
import org.opt4j.operators.crossover.CrossoverDouble;
import org.opt4j.operators.normalize.NormalizeDouble;

public class CrossoverDoubleUnfairAverage
extends CrossoverDouble {
    protected final double alpha;

    @Inject
    public CrossoverDoubleUnfairAverage(@Constant(value="alpha", namespace=CrossoverDoubleUnfairAverage.class) double alpha, NormalizeDouble normalize, Rand random) {
        super(normalize, random);
        this.alpha = alpha;
    }

    @Override
    protected void crossover(List<Double> p1, List<Double> p2, List<Double> o1, List<Double> o2) {
        int size = p1.size();
        int j = this.random.nextInt(size);
        for (int i = 0; i < size; ++i) {
            double z2;
            double z1;
            double x = p1.get(i);
            double y = p2.get(i);
            if (i <= j) {
                z1 = (1.0 + this.alpha) * x - this.alpha * y;
                z2 = (1.0 - this.alpha) * x + this.alpha * y;
            } else {
                z1 = -this.alpha * x + (1.0 + this.alpha) * y;
                z2 = this.alpha * x + (1.0 - this.alpha) * y;
            }
            o1.add(z1);
            o2.add(z2);
        }
    }
}

