/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opt4j.core.Genotype;
import org.opt4j.core.genotype.CompositeGenotype;
import org.opt4j.core.optimizer.IncompatibilityException;
import org.opt4j.core.optimizer.Operator;
import org.opt4j.core.start.Parameters;
import org.opt4j.operators.Apply;
import org.opt4j.operators.GenericOperator;

public abstract class AbstractGenericOperator<O extends Operator<?>, Q extends Operator<?>>
implements GenericOperator<O> {
    protected SortedMap<Class<? extends Genotype>, O> classOperators = new TreeMap<Class<Genotype>, O>(new ClassComparator());
    protected Map<OperatorPredicate, O> genericOperators = new HashMap<OperatorPredicate, O>();
    protected List<Class<? extends Q>> cldef = new ArrayList<Class<? extends Q>>();

    public AbstractGenericOperator(Class<? extends Q> ... clazzes) {
        for (Class<? extends Q> cl : clazzes) {
            this.cldef.add(cl);
        }
    }

    @Inject
    protected synchronized void inject(OperatorHolder<Q> holder) {
        if (this.classOperators.isEmpty()) {
            this.classOperators.put(CompositeGenotype.class, null);
            holder.add(this.cldef);
            for (Map.Entry<OperatorPredicate, Q> entry : holder.getMap().entrySet()) {
                this.addOperator(entry.getKey(), (Operator)entry.getValue());
            }
        }
    }

    @Override
    public void addOperator(OperatorPredicate predicate, O operator) {
        if (predicate instanceof OperatorClassPredicate) {
            Class<? extends Genotype> clazz = ((OperatorClassPredicate)predicate).getClazz();
            this.classOperators.put(clazz, operator);
        } else {
            this.genericOperators.put(predicate, operator);
        }
    }

    @Override
    public O getOperator(Genotype genotype) {
        if (this.classOperators.containsKey(genotype.getClass())) {
            return (O)((Operator)this.classOperators.get(genotype.getClass()));
        }
        for (Map.Entry<OperatorPredicate, O> entry : this.genericOperators.entrySet()) {
            if (!entry.getKey().evaluate(genotype)) continue;
            return (O)((Operator)entry.getValue());
        }
        for (Map.Entry<Object, O> entry : this.classOperators.entrySet()) {
            Class c = (Class)entry.getKey();
            if (!c.isAssignableFrom(genotype.getClass())) continue;
            Operator operator = (Operator)entry.getValue();
            this.addOperator(new OperatorClassPredicate(genotype.getClass()), operator);
            return (O)operator;
        }
        throw new IncompatibilityException("No handler found for " + genotype.getClass() + " in " + this.getClass());
    }

    @Override
    public Collection<O> getOperators() {
        HashSet<O> set = new HashSet<O>();
        set.addAll(this.classOperators.values());
        set.addAll(this.genericOperators.values());
        return set;
    }

    protected static <O> Class<? extends Genotype> getTarget(O operator) {
        Apply apply = operator.getClass().getAnnotation(Apply.class);
        if (apply != null) {
            return apply.value();
        }
        Type type = Parameters.getType(Operator.class, operator, (String)"G");
        if (type != null) {
            Class<Genotype> target = Parameters.getClass((Type)type).asSubclass(Genotype.class);
            return target;
        }
        throw new IllegalArgumentException("No target specified for the operator " + operator.getClass().getName() + ". Either parameterize the Operator or use the " + Apply.class.getName() + " annotation to specify a target.");
    }

    public static class OperatorClassPredicate
    implements OperatorPredicate {
        protected final Class<? extends Genotype> clazz;

        public OperatorClassPredicate(Class<? extends Genotype> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean evaluate(Genotype genotype) {
            return this.clazz.equals(genotype.getClass());
        }

        public Class<? extends Genotype> getClazz() {
            return this.clazz;
        }

        public String toString() {
            return "Predicate [clazz=" + this.clazz.getSimpleName() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OperatorClassPredicate other = (OperatorClassPredicate)obj;
            return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
        }
    }

    public static class OperatorVoidPredicate
    implements OperatorPredicate {
        @Override
        public boolean evaluate(Genotype genotype) {
            return false;
        }

        public String toString() {
            return "Predicate Void";
        }
    }

    public static interface OperatorPredicate {
        public boolean evaluate(Genotype var1);
    }

    protected static class OperatorHolder<P> {
        @Inject(optional=true)
        protected Map<OperatorPredicate, P> map = new HashMap<OperatorPredicate, P>();
        @Inject
        protected Injector injector;
        protected Collection<Class<? extends P>> clazzes = new ArrayList<Class<? extends P>>();

        protected OperatorHolder() {
        }

        public void add(Collection<Class<? extends P>> clazzes) {
            this.clazzes.addAll(clazzes);
        }

        public Map<OperatorPredicate, P> getMap() {
            HashMap<OperatorPredicate, Object> map = new HashMap<OperatorPredicate, Object>();
            for (Class<? extends P> clazz : this.clazzes) {
                Object p = this.injector.getInstance(clazz);
                map.put(new OperatorClassPredicate(AbstractGenericOperator.getTarget((Operator)p)), p);
            }
            for (Map.Entry entry : this.map.entrySet()) {
                OperatorPredicate predicate = (OperatorPredicate)entry.getKey();
                if (predicate instanceof OperatorVoidPredicate) {
                    predicate = new OperatorClassPredicate(AbstractGenericOperator.getTarget((Operator)entry.getValue()));
                }
                map.put(predicate, entry.getValue());
            }
            return map;
        }
    }

    protected static class ClassComparator
    implements Comparator<Class<? extends Genotype>> {
        protected ClassComparator() {
        }

        @Override
        public int compare(Class<? extends Genotype> arg0, Class<? extends Genotype> arg1) {
            if (arg0.equals(arg1)) {
                return 0;
            }
            if (arg0.isAssignableFrom(arg1)) {
                return 1;
            }
            if (arg1.isAssignableFrom(arg0)) {
                return -1;
            }
            return arg0.getCanonicalName().compareTo(arg1.getCanonicalName());
        }
    }
}

