/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.zdt;

import org.opt4j.benchmarks.BinaryCopyDecoder;
import org.opt4j.benchmarks.BinaryCreator;
import org.opt4j.benchmarks.BinaryToDoubleDecoder;
import org.opt4j.benchmarks.Bits;
import org.opt4j.benchmarks.DoubleCopyDecoder;
import org.opt4j.benchmarks.DoubleCreator;
import org.opt4j.benchmarks.N;
import org.opt4j.benchmarks.zdt.ZDT1;
import org.opt4j.benchmarks.zdt.ZDT2;
import org.opt4j.benchmarks.zdt.ZDT3;
import org.opt4j.benchmarks.zdt.ZDT4;
import org.opt4j.benchmarks.zdt.ZDT5;
import org.opt4j.benchmarks.zdt.ZDT5BinaryCreator;
import org.opt4j.benchmarks.zdt.ZDT6;
import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.config.annotations.Order;
import org.opt4j.core.config.annotations.Required;
import org.opt4j.core.problem.ProblemModule;

@Info(value="ZDT Problem Suite.")
public class ZDTModule
extends ProblemModule {
    @Order(value=0)
    @Info(value="The ZDT function.")
    protected Function function = Function.ZDT1;
    @Order(value=1)
    @Info(value="The size of the search space.")
    protected int n = 30;
    @Order(value=2)
    @Required(property="function", elements={"ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT6"})
    @Info(value="The encoding of the optimization problem.")
    protected Encoding encoding = Encoding.BINARY;
    @Order(value=3)
    @Required(property="encoding", elements={"BINARY"})
    @Info(value="The number of bits per double value.")
    protected int bits = 30;

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
        this.validate();
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
        this.validate();
        switch (function) {
            case ZDT1: {
                this.n = 30;
                break;
            }
            case ZDT2: {
                this.n = 30;
                break;
            }
            case ZDT3: {
                this.n = 30;
                break;
            }
            case ZDT4: {
                this.n = 10;
                break;
            }
            case ZDT5: {
                this.n = 11;
                break;
            }
            case ZDT6: {
                this.n = 10;
                break;
            }
            default: {
                this.n = 30;
            }
        }
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    protected void validate() {
        if (this.function == Function.ZDT5 && this.encoding == Encoding.DOUBLE) {
            this.encoding = Encoding.BINARY;
        }
    }

    public void config() {
        this.validate();
        Class creator = null;
        Class decoder = null;
        Class evaluator = null;
        switch (this.encoding) {
            case BINARY: {
                if (this.function == Function.ZDT5) {
                    creator = ZDT5BinaryCreator.class;
                    decoder = BinaryCopyDecoder.class;
                    break;
                }
                creator = BinaryCreator.class;
                decoder = BinaryToDoubleDecoder.class;
                break;
            }
            case DOUBLE: {
                creator = DoubleCreator.class;
                decoder = DoubleCopyDecoder.class;
            }
        }
        switch (this.function) {
            case ZDT1: {
                evaluator = ZDT1.class;
                break;
            }
            case ZDT2: {
                evaluator = ZDT2.class;
                break;
            }
            case ZDT3: {
                evaluator = ZDT3.class;
                break;
            }
            case ZDT4: {
                evaluator = ZDT4.class;
                break;
            }
            case ZDT5: {
                evaluator = ZDT5.class;
                break;
            }
            case ZDT6: {
                evaluator = ZDT6.class;
                break;
            }
        }
        this.bindConstant(N.class).to(this.n);
        this.bindConstant(Bits.class).to(this.bits);
        this.bindProblem(creator, decoder, evaluator);
    }

    public static enum Encoding {
        DOUBLE,
        BINARY;

    }

    public static enum Function {
        ZDT1,
        ZDT2,
        ZDT3,
        ZDT4,
        ZDT5,
        ZDT6;

    }
}

