/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.wfg;

import java.util.List;

class WFGTransFunctions {
    WFGTransFunctions() {
    }

    public static double corretToZeroOne(double a) {
        double epsilon = 1.0E-10;
        double WFG_min = 0.0;
        double WFG_max = 1.0;
        double min_epsilon = 0.0 - epsilon;
        double max_epsilon = 1.0 + epsilon;
        if (a <= 0.0 && a >= min_epsilon) {
            return 0.0;
        }
        if (a >= 1.0 && a <= max_epsilon) {
            return 1.0;
        }
        return a;
    }

    public static double b_poly(double y, double alpha) {
        assert (y >= 0.0);
        assert (y <= 1.0);
        assert (alpha > 0.0);
        assert (alpha != 1.0);
        double result = Math.pow(y, alpha);
        result = WFGTransFunctions.corretToZeroOne(result);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        return result;
    }

    public static double b_flat(double y, double A, double B, double C) {
        assert (y >= 0.0);
        assert (y <= 1.0);
        assert (A >= 0.0);
        assert (A <= 1.0);
        assert (B >= 0.0);
        assert (B <= 1.0);
        assert (C >= 0.0);
        assert (C <= 1.0);
        assert (B < C);
        assert (B != 0.0 || A == 0.0);
        assert (B != 0.0 || C != 1.0);
        assert (C != 1.0 || A == 1.0);
        assert (C != 1.0 || B != 0.0);
        double tmp1 = Math.min(0.0, Math.floor(y - B)) * A * (B - y) / B;
        double tmp2 = Math.min(0.0, Math.floor(C - y)) * (1.0 - A) * (y - C) / (1.0 - C);
        double result = A + tmp1 - tmp2;
        result = WFGTransFunctions.corretToZeroOne(result);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        return result;
    }

    public static double b_param(double y, double u, double A, double B, double C) {
        assert (y >= 0.0);
        assert (y <= 1.0);
        assert (u >= 0.0);
        assert (u <= 1.0);
        assert (A > 0.0);
        assert (A < 1.0);
        assert (B > 0.0);
        assert (B < C);
        double v = A - (1.0 - 2.0 * u) * Math.abs(Math.floor(0.5 - u) + A);
        double result = Math.pow(y, B + (C - B) * v);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        result = WFGTransFunctions.corretToZeroOne(result);
        return result;
    }

    public static double s_linear(double y, double A) {
        assert (y >= 0.0);
        assert (y <= 1.0);
        assert (A > 0.0);
        assert (A < 1.0);
        double result = Math.abs(y - A) / Math.abs(Math.floor(A - y) + A);
        result = WFGTransFunctions.corretToZeroOne(result);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        return result;
    }

    public static double s_decept(double y, double A, double B, double C) {
        assert (y >= 0.0);
        assert (y <= 1.0);
        assert (A > 0.0);
        assert (A < 1.0);
        assert (B > 0.0);
        assert (B < 1.0);
        assert (C > 0.0);
        assert (C < 1.0);
        assert (A - B > 0.0);
        assert (A + B < 1.0);
        double tmp1 = Math.floor(y - A + B) * (1.0 - C + (A - B) / B) / (A - B);
        double tmp2 = Math.floor(A + B - y) * (1.0 - C + (1.0 - A - B) / B) / (1.0 - A - B);
        double result = 1.0 + (Math.abs(y - A) - B) * (tmp1 + tmp2 + 1.0 / B);
        result = WFGTransFunctions.corretToZeroOne(result);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        return result;
    }

    public static double s_multi(double y, double A, double B, double C) {
        assert (y >= 0.0);
        assert (y <= 1.0);
        assert (A >= 1.0);
        assert (B >= 0.0);
        assert ((4.0 * A + 2.0) * Math.PI >= 4.0 * B);
        assert (C > 0.0);
        assert (C < 1.0);
        double tmp1 = Math.abs(y - C) / (2.0 * (Math.floor(C - y) + C));
        double tmp2 = (4.0 * A + 2.0) * Math.PI * (0.5 - tmp1);
        double result = (1.0 + Math.cos(tmp2) + 4.0 * B * Math.pow(tmp1, 2.0)) / (B + 2.0);
        result = WFGTransFunctions.corretToZeroOne(result);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        return result;
    }

    public static double r_sum(List<Double> y, List<Double> w) {
        assert (!y.isEmpty());
        assert (w.size() == y.size());
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < y.size(); ++i) {
            assert (w.get(i) > 0.0);
            numerator += w.get(i) * y.get(i);
            denominator += w.get(i).doubleValue();
        }
        double result = numerator / denominator;
        result = WFGTransFunctions.corretToZeroOne(result);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        return result;
    }

    public static double r_nonsep(List<Double> y, int A) {
        int y_len = y.size();
        assert (y_len != 0);
        assert (A >= 1);
        assert (A <= y_len);
        assert (y.size() % A == 0);
        double numerator = 0.0;
        for (int j = 0; j < y_len; ++j) {
            numerator += y.get(j).doubleValue();
            for (int k = 0; k <= A - 2; ++k) {
                numerator += Math.abs(y.get(j) - y.get((j + k + 1) % y_len));
            }
        }
        double tmp = Math.ceil((double)A / 2.0);
        double denominator = (double)y_len * tmp * (1.0 + 2.0 * (double)A - 2.0 * tmp) / (double)A;
        double result = numerator / denominator;
        result = WFGTransFunctions.corretToZeroOne(result);
        assert (result >= 0.0) : result;
        assert (result <= 1.0) : result;
        return result;
    }
}

