/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.wfg;

import java.util.List;

class WFGShapeFunctions {
    WFGShapeFunctions() {
    }

    public static double linear(List<Double> x, int m) {
        int M2 = x.size();
        double result = 1.0;
        for (int i = 1; i <= M2 - m; ++i) {
            result *= x.get(i - 1).doubleValue();
        }
        if (m != 1) {
            result *= 1.0 - x.get(M2 - m);
        }
        assert (result <= 1.0);
        assert (result >= 0.0);
        return result;
    }

    public static double convex(List<Double> x, int m) {
        int M2 = x.size();
        double result = 1.0;
        for (int i = 1; i <= M2 - m; ++i) {
            result *= 1.0 - Math.cos(x.get(i - 1) * Math.PI / 2.0);
        }
        if (m != 1) {
            result *= 1.0 - Math.sin(x.get(M2 - m) * Math.PI / 2.0);
        }
        assert (result <= 1.0);
        assert (result >= 0.0);
        return result;
    }

    public static double concave(List<Double> x, int m) {
        int M2 = x.size();
        double result = 1.0;
        for (int i = 1; i <= M2 - m; ++i) {
            result *= Math.sin(x.get(i - 1) * Math.PI / 2.0);
        }
        if (m != 1) {
            result *= Math.cos(x.get(M2 - m) * Math.PI / 2.0);
        }
        assert (result <= 1.0);
        assert (result >= 0.0);
        return result;
    }

    public static double mixed(List<Double> x, int A, double alpha) {
        assert (!x.isEmpty());
        assert (A >= 1);
        assert (alpha > 0.0);
        double tmp = 2.0 * (double)A * Math.PI;
        double result = Math.pow(1.0 - x.get(0) - Math.cos(tmp * x.get(0) + 1.5707963267948966) / tmp, alpha);
        assert (result <= 1.0);
        assert (result >= 0.0);
        return result;
    }

    public static double disc(List<Double> x, int A, double alpha, double beta) {
        assert (!x.isEmpty());
        assert (A >= 1);
        assert (alpha > 0.0);
        assert (beta > 0.0);
        double tmp1 = (double)A * Math.pow(x.get(0), beta) * Math.PI;
        double result = 1.0 - Math.pow(x.get(0), alpha) * Math.pow(Math.cos(tmp1), 2.0);
        assert (result <= 1.0);
        assert (result >= 0.0);
        return result;
    }
}

