/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.wfg;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.opt4j.benchmarks.DoubleString;
import org.opt4j.benchmarks.K;
import org.opt4j.benchmarks.M;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;

public abstract class WFGEvaluator
implements Evaluator<DoubleString> {
    protected final int M;
    protected final int k;
    protected final List<Objective> keys = new ArrayList<Objective>();

    @Inject
    public WFGEvaluator(@K int k, @M int M2) {
        this.M = M2;
        this.k = k;
        for (int i = 0; i < M2; ++i) {
            this.keys.add(new Objective("f" + (i + 1)));
        }
    }

    public abstract List<Double> f(List<Double> var1);

    public Objectives evaluate(DoubleString phenotype) {
        List<Double> f = this.f((List<Double>)((Object)phenotype));
        assert (f.size() == this.keys.size());
        Objectives objectives = new Objectives();
        for (int i = 0; i < this.M; ++i) {
            objectives.add(this.keys.get(i), f.get(i).doubleValue());
        }
        return objectives;
    }

    protected static List<Boolean> createA(int M2, boolean degenerate) {
        assert (M2 >= 2);
        ArrayList<Boolean> A = new ArrayList<Boolean>();
        for (int i = 0; i < M2 - 1; ++i) {
            A.add(!degenerate || i == 0);
        }
        return A;
    }

    protected static List<Double> calculateF(List<Double> x, List<Double> h) {
        assert (x.size() == h.size());
        int M2 = h.size();
        ArrayList<Double> S = new ArrayList<Double>();
        for (int m = 1; m <= M2; ++m) {
            S.add((double)m * 2.0);
        }
        return WFGEvaluator.caculateF(x, h, S);
    }

    protected static List<Double> normalizeZ(List<Double> z, List<Double> z_max) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < z.size(); ++i) {
            assert (z.get(i) >= 0.0);
            assert (z.get(i) <= z_max.get(i));
            assert (z_max.get(i) > 0.0);
            result.add(z.get(i) / z_max.get(i));
        }
        return result;
    }

    protected static List<Double> calculateX(List<Double> t_p, List<Boolean> A) {
        int size = t_p.size();
        assert (size != 0);
        assert (A.size() == t_p.size() - 1);
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < t_p.size() - 1; ++i) {
            boolean A_i = A.get(i) != false;
            double tmp1 = Math.max(t_p.get(size - 1), (double)A_i);
            result.add(tmp1 * (t_p.get(i) - 0.5) + 0.5);
        }
        result.add(t_p.get(size - 1));
        return result;
    }

    protected static List<Double> caculateF(List<Double> x, List<Double> h, List<Double> S) {
        assert (x.size() == h.size());
        assert (h.size() == S.size());
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < h.size(); ++i) {
            assert (S.get(i) > 0.0);
            result.add(x.get(x.size() - 1) + S.get(i) * h.get(i));
        }
        return result;
    }
}

