/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.queens;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.opt4j.benchmarks.queens.QueensBoard;
import org.opt4j.benchmarks.queens.QueensProblem;
import org.opt4j.core.Genotype;
import org.opt4j.core.common.random.Rand;
import org.opt4j.satdecoding.AbstractSATDecoder;
import org.opt4j.satdecoding.Constraint;
import org.opt4j.satdecoding.Literal;
import org.opt4j.satdecoding.Model;
import org.opt4j.satdecoding.SATManager;

public class QueensSATDecoder
extends AbstractSATDecoder<Genotype, QueensBoard> {
    protected final QueensProblem problem;

    @Inject
    public QueensSATDecoder(SATManager satManager, QueensProblem problem, Rand random) {
        super(satManager, random);
        this.problem = problem;
    }

    public QueensBoard convertModel(Model model) {
        int size = this.problem.size();
        QueensBoard queensBoard = new QueensBoard(size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                queensBoard.setQueen(i, j, model.get((Object)(i * size + j)));
            }
        }
        return queensBoard;
    }

    public Set<Constraint> createConstraints() {
        int i;
        int k;
        int j;
        Constraint constraint;
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        int size = this.problem.size();
        for (int i2 = 0; i2 < size; ++i2) {
            constraint = new Constraint("=", 1);
            for (j = 0; j < size; ++j) {
                constraint.add(new Literal((Object)(i2 * size + j), true));
            }
            constraints.add(constraint);
        }
        for (int j2 = 0; j2 < size; ++j2) {
            constraint = new Constraint("=", 1);
            for (int i3 = 0; i3 < size; ++i3) {
                constraint.add(new Literal((Object)(i3 * size + j2), true));
            }
            constraints.add(constraint);
        }
        for (k = -size + 1; k < size; ++k) {
            constraint = new Constraint("<=", 1);
            for (j = 0; j < size; ++j) {
                i = k + j;
                if (0 > i || i >= size) continue;
                constraint.add(new Literal((Object)(i * size + j), true));
            }
            constraints.add(constraint);
        }
        for (k = 0; k < 2 * size - 1; ++k) {
            constraint = new Constraint("<=", 1);
            for (j = 0; j < size; ++j) {
                i = k - j;
                if (0 > i || i >= size) continue;
                constraint.add(new Literal((Object)(i * size + j), true));
            }
            constraints.add(constraint);
        }
        return constraints;
    }
}

