/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.queens;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.core.start.Constant;

public class QueensProblem {
    protected final int[][][] board;
    protected final int size;
    protected final int dim;
    protected final Random random;

    @Inject
    public QueensProblem(@Constant(value="size", namespace=QueensProblem.class) int size, @Constant(value="dim", namespace=QueensProblem.class) int dim, @Constant(value="seed", namespace=QueensProblem.class) int seed) {
        this.random = new Random(seed);
        this.size = size;
        this.dim = dim;
        this.board = new int[dim][size][size];
        for (int d = 0; d < dim; ++d) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    this.board[d][i][j] = this.random.nextInt(100);
                }
            }
        }
    }

    public int costs(int d, int i, int j) {
        return this.board[d][i][j];
    }

    public int size() {
        return this.size;
    }

    public int dim() {
        return this.dim;
    }
}

