/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.queens;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.benchmarks.queens.QueensBoard;
import org.opt4j.benchmarks.queens.QueensProblem;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.PermutationGenotype;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;

public class QueensPermutationDecoder
implements Decoder<PermutationGenotype<Integer>, QueensBoard>,
Creator<PermutationGenotype<Integer>> {
    protected final QueensProblem problem;
    protected final Random random;

    @Inject
    public QueensPermutationDecoder(QueensProblem problem, Rand random) {
        this.problem = problem;
        this.random = random;
    }

    public PermutationGenotype<Integer> create() {
        int size = this.problem.size();
        PermutationGenotype genotype = new PermutationGenotype();
        for (int i = 0; i < size; ++i) {
            genotype.add((Object)i);
        }
        genotype.init(this.random);
        return genotype;
    }

    public QueensBoard decode(PermutationGenotype<Integer> permutation) {
        int size = this.problem.size();
        QueensBoard queensBoard = new QueensBoard(size);
        for (int i = 0; i < permutation.size(); ++i) {
            queensBoard.setQueen(i, (Integer)permutation.get(i), true);
        }
        return queensBoard;
    }
}

