/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.queens;

import org.opt4j.benchmarks.queens.QueensCopyDecoder;
import org.opt4j.benchmarks.queens.QueensErrorEvaluator;
import org.opt4j.benchmarks.queens.QueensEvaluator;
import org.opt4j.benchmarks.queens.QueensPermutationDecoder;
import org.opt4j.benchmarks.queens.QueensProblem;
import org.opt4j.benchmarks.queens.QueensSATDecoder;
import org.opt4j.core.config.annotations.Icon;
import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.config.annotations.Order;
import org.opt4j.core.problem.ProblemModule;
import org.opt4j.core.start.Constant;

@Icon(value="icons/gear-gray.png")
@Info(value="The n-Queens problem as optimization problem with linear objective functions.")
public class QueensModule
extends ProblemModule {
    @Info(value="The size of the board (size*size).")
    @Order(value=0)
    @Constant(value="size", namespace=QueensProblem.class)
    protected int size = 40;
    @Info(value="The number of objective functions.")
    @Order(value=1)
    @Constant(value="dim", namespace=QueensProblem.class)
    protected int dimensions = 2;
    @Info(value="The seed of the problem generator (for the objective function).")
    @Order(value=2)
    @Constant(value="seed", namespace=QueensProblem.class)
    protected int seed = 0;
    @Info(value="the used decoder")
    @Order(value=3)
    protected Dec decoder = Dec.SAT;

    public void config() {
        this.bind(QueensProblem.class).in(SINGLETON);
        Class creatorClass = null;
        Class decoderClass = null;
        switch (this.decoder) {
            case SAT: {
                creatorClass = QueensSATDecoder.class;
                decoderClass = QueensSATDecoder.class;
                break;
            }
            case PERMUTATION: {
                creatorClass = QueensPermutationDecoder.class;
                decoderClass = QueensPermutationDecoder.class;
                break;
            }
            case COPY: {
                creatorClass = QueensCopyDecoder.class;
                decoderClass = QueensCopyDecoder.class;
            }
        }
        this.bindProblem(creatorClass, decoderClass, QueensErrorEvaluator.class);
        this.addEvaluator(QueensEvaluator.class);
    }

    public Dec getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Dec decoder) {
        this.decoder = decoder;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public static enum Dec {
        COPY,
        PERMUTATION,
        SAT;

    }
}

