/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.queens;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.opt4j.benchmarks.queens.QueensBoard;
import org.opt4j.benchmarks.queens.QueensProblem;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;

public class QueensEvaluator
implements Evaluator<QueensBoard> {
    protected final QueensProblem problem;
    protected final List<Objective> objectives = new ArrayList<Objective>();

    @Inject
    public QueensEvaluator(QueensProblem problem) {
        this.problem = problem;
    }

    @Inject
    public void init() {
        for (int d = 0; d < this.problem.dim(); ++d) {
            this.objectives.add(new Objective("sum" + d, Objective.Sign.MIN));
        }
    }

    public Objectives evaluate(QueensBoard queensBoard) {
        Objectives obj = new Objectives();
        for (int d = 0; d < this.problem.dim(); ++d) {
            Objective objective = this.objectives.get(d);
            if (queensBoard.isFeasible()) {
                int sum = this.sum(queensBoard, d);
                obj.add(objective, sum);
                continue;
            }
            obj.add(objective, Objective.INFEASIBLE);
        }
        return obj;
    }

    private int sum(QueensBoard board, int d) {
        int sum = 0;
        for (int i = 0; i < this.problem.size(); ++i) {
            for (int j = 0; j < this.problem.size(); ++j) {
                if (!board.isQueen(i, j)) continue;
                sum += this.problem.costs(d, i, j);
            }
        }
        return sum;
    }
}

