/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.queens;

import com.google.inject.Inject;
import org.opt4j.benchmarks.queens.QueensBoard;
import org.opt4j.benchmarks.queens.QueensProblem;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.problem.Priority;

@Priority(value=-10)
public class QueensErrorEvaluator
implements Evaluator<QueensBoard> {
    protected final QueensProblem problem;
    protected final Objective error = new Objective("error", Objective.Sign.MIN);

    @Inject
    public QueensErrorEvaluator(QueensProblem problem) {
        this.problem = problem;
    }

    public Objectives evaluate(QueensBoard queensBoard) {
        int errors = this.countErrors(queensBoard);
        Objectives objectives = new Objectives();
        objectives.add(this.error, errors);
        queensBoard.setFeasible(errors == 0);
        return objectives;
    }

    private int countErrors(QueensBoard queensBoard) {
        int i;
        int k;
        int j;
        int sum;
        int errorcount = 0;
        int size = this.problem.size();
        for (int i2 = 0; i2 < size; ++i2) {
            sum = 0;
            for (j = 0; j < size; ++j) {
                if (!queensBoard.isQueen(i2, j)) continue;
                ++sum;
            }
            sum = Math.abs(1 - sum);
            errorcount += sum;
            sum = 0;
            for (j = 0; j < size; ++j) {
                if (!queensBoard.isQueen(j, i2)) continue;
                ++sum;
            }
            sum = Math.abs(1 - sum);
            errorcount += sum;
        }
        for (k = -size + 1; k < size; ++k) {
            sum = 0;
            for (j = 0; j < size; ++j) {
                i = k + j;
                if (0 > i || i >= size || !queensBoard.isQueen(j, i)) continue;
                ++sum;
            }
            sum = Math.max(0, sum - 1);
            errorcount += sum;
        }
        for (k = 0; k < 2 * size - 1; ++k) {
            sum = 0;
            for (j = 0; j < size; ++j) {
                i = k - j;
                if (0 > i || i >= size || !queensBoard.isQueen(j, i)) continue;
                ++sum;
            }
            sum = Math.max(0, sum - 1);
            errorcount += sum;
        }
        return errorcount;
    }
}

