/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.queens;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.benchmarks.queens.QueensBoard;
import org.opt4j.benchmarks.queens.QueensProblem;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.BooleanGenotype;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;

public class QueensCopyDecoder
implements Decoder<BooleanGenotype, QueensBoard>,
Creator<BooleanGenotype> {
    protected final QueensProblem problem;
    protected final Random random;

    @Inject
    public QueensCopyDecoder(QueensProblem problem, Rand random) {
        this.problem = problem;
        this.random = random;
    }

    public BooleanGenotype create() {
        int size = this.problem.size();
        BooleanGenotype vector = new BooleanGenotype();
        vector.init(this.random, size * size);
        return vector;
    }

    public QueensBoard decode(BooleanGenotype vector) {
        int size = this.problem.size();
        QueensBoard queensBoard = new QueensBoard(size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                queensBoard.setQueen(i, j, (Boolean)vector.get(i + j * size));
            }
        }
        return queensBoard;
    }
}

