/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.knapsack;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.opt4j.benchmarks.knapsack.Item;
import org.opt4j.benchmarks.knapsack.ItemSelection;
import org.opt4j.benchmarks.knapsack.Knapsack;
import org.opt4j.benchmarks.knapsack.KnapsackProblem;
import org.opt4j.core.Genotype;
import org.opt4j.core.common.random.Rand;
import org.opt4j.satdecoding.AbstractSATDecoder;
import org.opt4j.satdecoding.Constraint;
import org.opt4j.satdecoding.Literal;
import org.opt4j.satdecoding.Model;
import org.opt4j.satdecoding.SATManager;

public class KnapsackSATCreatorDecoder
extends AbstractSATDecoder<Genotype, ItemSelection> {
    private final KnapsackProblem problem;

    @Inject
    public KnapsackSATCreatorDecoder(SATManager manager, KnapsackProblem problem, Rand random) {
        super(manager, random);
        this.problem = problem;
    }

    public Set<Constraint> createConstraints() {
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        for (Knapsack knapsack : this.problem.getKnapsacks()) {
            Constraint constraint = new Constraint(Constraint.Operator.LE, (int)Math.floor(knapsack.getCapacity()));
            for (Item item : this.problem.getItems()) {
                constraint.add(knapsack.getWeight(item), new Literal((Object)item, true));
            }
            constraints.add(constraint);
        }
        return constraints;
    }

    public ItemSelection convertModel(Model model) {
        ItemSelection itemSelection = new ItemSelection();
        for (Item item : this.problem.getItems()) {
            if (!model.get((Object)item).booleanValue()) continue;
            itemSelection.add(item);
        }
        return itemSelection;
    }
}

