/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.knapsack;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opt4j.benchmarks.knapsack.Item;
import org.opt4j.benchmarks.knapsack.ItemSelection;
import org.opt4j.benchmarks.knapsack.Knapsack;
import org.opt4j.benchmarks.knapsack.KnapsackProblem;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.problem.Priority;

@Priority(value=0)
public class KnapsackProfitEvaluator
implements Evaluator<ItemSelection> {
    protected final Map<Knapsack, Objective> profitObjectives = new HashMap<Knapsack, Objective>();
    protected KnapsackProblem problem;

    @Inject
    public KnapsackProfitEvaluator(KnapsackProblem problem) {
        this.problem = problem;
        int i = 0;
        for (Knapsack knapsack : problem.getKnapsacks()) {
            this.profitObjectives.put(knapsack, new Objective("profit" + i++, Objective.Sign.MAX));
        }
    }

    public Objectives evaluate(ItemSelection itemSelection) {
        Objectives objectives = new Objectives();
        for (Knapsack knapsack : this.problem.getKnapsacks()) {
            if (itemSelection.isFeasible()) {
                objectives.add(this.profitObjectives.get(knapsack), this.getProfit(knapsack, itemSelection));
                continue;
            }
            objectives.add(this.profitObjectives.get(knapsack), Objective.INFEASIBLE);
        }
        return objectives;
    }

    protected int getProfit(Knapsack knapsack, Collection<Item> items) {
        int profit = 0;
        for (Item i : items) {
            profit += knapsack.getProfit(i);
        }
        return profit;
    }
}

