/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.knapsack;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opt4j.benchmarks.knapsack.Item;
import org.opt4j.benchmarks.knapsack.Knapsack;
import org.opt4j.benchmarks.knapsack.KnapsackProblem;
import org.opt4j.core.common.random.RandomMersenneTwister;
import org.opt4j.core.start.Constant;

@Singleton
public class KnapsackProblemRandom
implements KnapsackProblem {
    protected final List<Knapsack> knapsacks = new ArrayList<Knapsack>();
    protected final List<Item> items = new ArrayList<Item>();

    @Inject
    public KnapsackProblemRandom(@Constant(value="items", namespace=KnapsackProblemRandom.class) int items, @Constant(value="knapsacks", namespace=KnapsackProblemRandom.class) int knapsacks, @Constant(value="seed", namespace=KnapsackProblemRandom.class) int seed) {
        for (int i = 0; i < items; ++i) {
            this.items.add(new Item(i + 1));
        }
        RandomMersenneTwister random = new RandomMersenneTwister((long)seed);
        for (int k = 0; k < knapsacks; ++k) {
            Knapsack knapsack = new Knapsack(k + 1);
            double capacity = 0.0;
            for (Item item : this.items) {
                int profit = random.nextInt(91) + 10;
                int weight = random.nextInt(91) + 10;
                knapsack.setProfit(item, profit);
                knapsack.setWeight(item, weight);
                capacity += 0.5 * (double)weight;
            }
            knapsack.setCapacity(capacity);
            this.knapsacks.add(knapsack);
        }
    }

    @Override
    public Collection<Knapsack> getKnapsacks() {
        return this.knapsacks;
    }

    @Override
    public Collection<Item> getItems() {
        return this.items;
    }
}

