/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.knapsack;

import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opt4j.benchmarks.knapsack.Item;
import org.opt4j.benchmarks.knapsack.Knapsack;
import org.opt4j.benchmarks.knapsack.KnapsackProblem;
import org.opt4j.core.start.Constant;

public class KnapsackProblemFile
implements KnapsackProblem {
    protected static final String INT = "[+-]?\\d+";
    protected static final String DOUBLE = "[+-]?\\d+(\\.\\d*)?";
    protected static final String BLANK = "[\\p{Blank}]*";
    protected static final String POSINT = "[-]?\\d+";
    protected static final String POSDOUBLE = "[-]?\\d+(\\.\\d*)?";
    protected final List<Knapsack> knapsacks = new ArrayList<Knapsack>();
    protected final List<Item> items = new ArrayList<Item>();

    @Inject
    public KnapsackProblemFile(@Constant(value="filename", namespace=KnapsackProblemFile.class) String filename) {
        FileReader fileReader;
        try {
            fileReader = new FileReader(filename);
        }
        catch (FileNotFoundException e1) {
            throw new IllegalArgumentException("Knapsack problem file not found " + filename, e1);
        }
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String line;
            Knapsack knapsack = null;
            Item item = null;
            while ((line = reader.readLine()) != null) {
                if (line.matches("[\\p{Blank}]*knapsack[\\p{Blank}]*[+-]?\\d+[\\p{Blank}]*:[\\p{Blank}]*")) {
                    knapsack = new Knapsack(this.getInt(line));
                    this.knapsacks.add(knapsack);
                    continue;
                }
                if (knapsack == null) {
                    throw new IllegalStateException("knapsack not initialized." + filename);
                }
                if (line.matches("[\\p{Blank}]*capacity:[\\p{Blank}]*[+-]?\\d+(\\.\\d*)?[\\p{Blank}]*")) {
                    double capacity = this.getDouble(line);
                    knapsack.setCapacity(capacity);
                    continue;
                }
                if (line.matches("[\\p{Blank}]*item[\\p{Blank}]*[+-]?\\d+[\\p{Blank}]*:[\\p{Blank}]*")) {
                    int i = this.getInt(line);
                    if (this.items.size() < i) {
                        item = new Item(this.getInt(line));
                        this.items.add(i - 1, item);
                        continue;
                    }
                    item = this.items.get(i - 1);
                    continue;
                }
                if (line.matches("[\\p{Blank}]*weight:[\\p{Blank}]*[+-]?\\d+(\\.\\d*)?[\\p{Blank}]*")) {
                    int weight = this.getInt(line);
                    knapsack.setWeight(item, weight);
                    continue;
                }
                if (!line.matches("[\\p{Blank}]*profit:[\\p{Blank}]*[+-]?\\d+(\\.\\d*)?[\\p{Blank}]*")) continue;
                int profit = this.getInt(line);
                knapsack.setProfit(item, profit);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    protected int getInt(String line) {
        Matcher matcher = Pattern.compile(POSINT).matcher(line);
        matcher.find();
        return new Integer(matcher.group());
    }

    protected double getDouble(String line) {
        Matcher matcher = Pattern.compile(POSDOUBLE).matcher(line);
        matcher.find();
        return new Double(matcher.group());
    }

    @Override
    public Collection<Knapsack> getKnapsacks() {
        return this.knapsacks;
    }

    @Override
    public Collection<Item> getItems() {
        return this.items;
    }
}

