/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.knapsack;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opt4j.benchmarks.knapsack.Item;
import org.opt4j.benchmarks.knapsack.ItemSelection;
import org.opt4j.benchmarks.knapsack.Knapsack;
import org.opt4j.benchmarks.knapsack.KnapsackProblem;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.problem.Priority;

@Priority(value=-10)
public class KnapsackOverloadEvaluator
implements Evaluator<ItemSelection> {
    protected Objective objectiveOverload = new Objective("overload", Objective.Sign.MIN);
    protected final Map<Knapsack, Objective> profitObjectives = new HashMap<Knapsack, Objective>();
    protected KnapsackProblem problem;

    @Inject
    public KnapsackOverloadEvaluator(KnapsackProblem problem) {
        this.problem = problem;
        int i = 0;
        for (Knapsack knapsack : problem.getKnapsacks()) {
            this.profitObjectives.put(knapsack, new Objective("profit" + i++, Objective.Sign.MAX));
        }
    }

    public Objectives evaluate(ItemSelection itemSelection) {
        double overload = 0.0;
        for (Knapsack knapsack : this.problem.getKnapsacks()) {
            overload += this.getOverload(knapsack, itemSelection);
        }
        Objectives objectives = new Objectives();
        objectives.add(this.objectiveOverload, overload);
        itemSelection.setFeasible(overload == 0.0);
        return objectives;
    }

    protected double getOverload(Knapsack knapsack, Collection<Item> items) {
        double weight = 0.0;
        for (Item i : items) {
            weight += (double)knapsack.getWeight(i);
        }
        return Math.max(0.0, weight - knapsack.getCapacity());
    }
}

