/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmarks.knapsack;

import org.opt4j.benchmarks.knapsack.KnapsackBinaryCreatorDecoder;
import org.opt4j.benchmarks.knapsack.KnapsackOverloadEvaluator;
import org.opt4j.benchmarks.knapsack.KnapsackProblem;
import org.opt4j.benchmarks.knapsack.KnapsackProblemFile;
import org.opt4j.benchmarks.knapsack.KnapsackProblemRandom;
import org.opt4j.benchmarks.knapsack.KnapsackProfitEvaluator;
import org.opt4j.benchmarks.knapsack.KnapsackSATCreatorDecoder;
import org.opt4j.core.config.annotations.File;
import org.opt4j.core.config.annotations.Required;
import org.opt4j.core.problem.ProblemModule;
import org.opt4j.core.start.Constant;

public class KnapsackModule
extends ProblemModule {
    protected int knapsacks = 5;
    protected int items = 250;
    @Required(property="testCase", elements={"MANUAL", "ZT1", "ZT2", "ZT3", "ZT4", "ZT5", "ZT6", "ZT7", "ZT8", "ZT9"})
    @Constant(value="seed", namespace=KnapsackProblemRandom.class)
    protected int seed = 0;
    @File
    @Required(property="testCase", elements={"FILE"})
    @Constant(value="filename", namespace=KnapsackProblemFile.class)
    protected String filename = "";
    protected Representation representation = Representation.BITSTRING;
    protected TestCase testCase = TestCase.MANUAL;

    protected void config() {
        switch (this.testCase) {
            case ZT1: {
                this.knapsacks = 2;
                this.items = 250;
                break;
            }
            case ZT2: {
                this.knapsacks = 3;
                this.items = 250;
                break;
            }
            case ZT3: {
                this.knapsacks = 5;
                this.items = 250;
                break;
            }
            case ZT4: {
                this.knapsacks = 2;
                this.items = 500;
                break;
            }
            case ZT5: {
                this.knapsacks = 3;
                this.items = 500;
                break;
            }
            case ZT6: {
                this.knapsacks = 5;
                this.items = 500;
                break;
            }
            case ZT7: {
                this.knapsacks = 2;
                this.items = 750;
                break;
            }
            case ZT8: {
                this.knapsacks = 3;
                this.items = 750;
                break;
            }
            case ZT9: {
                this.knapsacks = 5;
                this.items = 750;
                break;
            }
        }
        this.bindConstant("items", KnapsackProblemRandom.class).to(this.items);
        this.bindConstant("knapsacks", KnapsackProblemRandom.class).to(this.knapsacks);
        if (this.testCase == TestCase.FILE) {
            this.bind(KnapsackProblem.class).to(KnapsackProblemFile.class).in(SINGLETON);
        } else {
            this.bind(KnapsackProblem.class).to(KnapsackProblemRandom.class).in(SINGLETON);
        }
        switch (this.representation) {
            case BITSTRING: {
                this.bindProblem(KnapsackBinaryCreatorDecoder.class, KnapsackBinaryCreatorDecoder.class, KnapsackProfitEvaluator.class);
                break;
            }
            case SAT: {
                this.bindProblem(KnapsackSATCreatorDecoder.class, KnapsackSATCreatorDecoder.class, KnapsackProfitEvaluator.class);
            }
        }
        this.addEvaluator(KnapsackOverloadEvaluator.class);
    }

    @Required(property="testCase", elements={"MANUAL"})
    public int getKnapsacks() {
        return this.knapsacks;
    }

    public void setKnapsacks(int knapsacks) {
        this.knapsacks = knapsacks;
    }

    @Required(property="testCase", elements={"MANUAL"})
    public int getItems() {
        return this.items;
    }

    public void setItems(int items) {
        this.items = items;
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public static enum Representation {
        BITSTRING,
        SAT;

    }

    public static enum TestCase {
        FILE,
        MANUAL,
        ZT1,
        ZT2,
        ZT3,
        ZT4,
        ZT5,
        ZT6,
        ZT7,
        ZT8,
        ZT9;

    }
}

